/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;

class ReplaceAggregatesWithCRVisitor
implements Visitor {
    private ResultColumnList rcl;
    private Class<?> skipOverClass;
    private int tableNumber;

    ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, int n) {
        this(resultColumnList, n, null);
    }

    ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, int n, Class<?> clazz) {
        this.rcl = resultColumnList;
        this.tableNumber = n;
        this.skipOverClass = clazz;
    }

    ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, Class<?> clazz) {
        this.rcl = resultColumnList;
        this.skipOverClass = clazz;
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof AggregateNode) {
            visitable = ((AggregateNode)visitable).replaceAggregatesWithColumnReferences(this.rcl, this.tableNumber);
        }
        return visitable;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(visitable);
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

