/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.Util;

final class AutoPositioningStream
extends BinaryToRawStream {
    private final ConnectionChild conChild;
    private long pos;
    private final PositionedStoreStream positionedStream;

    AutoPositioningStream(ConnectionChild connectionChild, InputStream inputStream, Object object) throws IOException {
        super(inputStream, object);
        this.positionedStream = (PositionedStoreStream)inputStream;
        this.pos = this.positionedStream.getPosition();
        this.conChild = connectionChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setPosition();
            }
            catch (EOFException eOFException) {
                return -1;
            }
            int n = this.positionedStream.read();
            if (n >= 0) {
                ++this.pos;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setPosition();
            }
            catch (EOFException eOFException) {
                return -1;
            }
            int n3 = this.positionedStream.read(byArray, n, n2);
            if (n3 > 0) {
                this.pos += (long)n3;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            this.setPosition();
            long l2 = this.positionedStream.skip(l);
            this.pos += l2;
            return l2;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void setPosition() throws IOException {
        try {
            if (this.pos != this.positionedStream.getPosition()) {
                this.positionedStream.reposition(this.pos);
            }
        }
        catch (StandardException standardException) {
            throw Util.newIOException(standardException);
        }
    }
}

