/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.LockException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.StoreException;

public class SQLExceptions {
    private static final SQLException[] EMPTY_EXCEPS = new SQLException[0];

    public static OpenJPAException getStore(SQLException se) {
        return SQLExceptions.getStore(se, null, null);
    }

    public static OpenJPAException getStore(SQLException se, Object failed) {
        return SQLExceptions.getStore(se, failed, null);
    }

    public static OpenJPAException getStore(SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(se.getMessage(), se, dict);
    }

    public static OpenJPAException getStore(SQLException se, DBDictionary dict, int level) {
        return SQLExceptions.getStore(se.getMessage(), se, dict, level);
    }

    public static OpenJPAException getStore(SQLException se, Object failed, DBDictionary dict) {
        return SQLExceptions.getStore(se.getMessage(), se, failed, dict, -1);
    }

    public static OpenJPAException getStore(SQLException se, Object failed, DBDictionary dict, int level) {
        return SQLExceptions.getStore(se.getMessage(), se, failed, dict, level);
    }

    public static OpenJPAException getStore(Localizer.Message msg, SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(msg.getMessage(), se, null, dict, -1);
    }

    public static OpenJPAException getStore(Localizer.Message msg, SQLException se, DBDictionary dict, int level) {
        return SQLExceptions.getStore(msg.getMessage(), se, null, dict, level);
    }

    public static OpenJPAException getStore(String msg, SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(msg, se, null, dict, -1);
    }

    public static OpenJPAException getStore(String msg, SQLException se, DBDictionary dict, int level) {
        return SQLExceptions.getStore(msg, se, null, dict, level);
    }

    public static OpenJPAException getStore(String msg, SQLException se, Object failed, DBDictionary dict) {
        return SQLExceptions.getStore(msg, se, failed, dict, -1);
    }

    public static OpenJPAException getStore(String msg, SQLException se, Object failed, DBDictionary dict, int level) {
        OpenJPAException storeEx;
        if (msg == null) {
            msg = se.getClass().getName();
        }
        Throwable[] ses = SQLExceptions.getSQLExceptions(se);
        OpenJPAException openJPAException = storeEx = dict == null ? new StoreException(msg).setFailedObject(failed).setNestedThrowables(ses) : dict.newStoreException(msg, (SQLException[])ses, failed);
        if (level != -1 && storeEx.getSubtype() == 1) {
            LockException lockEx = (LockException)storeEx;
            lockEx.setLockLevel(level);
        }
        return storeEx;
    }

    private static SQLException[] getSQLExceptions(SQLException se) {
        if (se == null) {
            return EMPTY_EXCEPS;
        }
        LinkedList<SQLException> errs = new LinkedList<SQLException>();
        while (se != null && !errs.contains(se)) {
            errs.add(se);
            se = se.getNextException();
        }
        return errs.toArray(new SQLException[errs.size()]);
    }
}

