/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package org.apache.myfaces.portlet.faces.preference;


import java.util.Arrays;
import java.util.List;

import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.faces.preference.Preference;

public class PreferenceImpl implements Preference
{
  private PortletPreferences mPreferences;
  private String mPreferenceKey = null;
  private PreferenceValuesList mPreferenceValues = null;

  public PreferenceImpl(PortletPreferences preferences)
  {
    super();
    mPreferences = preferences;
  }
  
  public PreferenceImpl(PortletPreferences preferences, String name)
  {
    this(preferences);
    mPreferenceKey = name;
  }
  
  public List getValues()
  {
    if (mPreferenceValues == null)
    {
      mPreferenceValues =  new PreferenceValuesList(this, Arrays.asList(mPreferences.getValues(mPreferenceKey, null)));
    }
    return mPreferenceValues;
  }
  
  public void setName(String name)
  {
    mPreferenceKey = name;
  }
  
  public String getName()
  {
    return mPreferenceKey;
  }
  
  public String getValue()
  {
    return mPreferences.getValue(mPreferenceKey, null);
  }
  
  public boolean isReadOnly()
  {
    return mPreferences.isReadOnly(mPreferenceKey);
  }
  
  public void reset() throws ReadOnlyException
  {
    mPreferences.reset(mPreferenceKey);
  }
  
  public void setValue(String value) throws ReadOnlyException
  {
    mPreferences.setValue(mPreferenceKey, value);
  }
  
  public void setValues(String[] values) throws ReadOnlyException
  {
    mPreferences.setValues(mPreferenceKey, values);
  }
}
