"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProbeClass = void 0;
class ProbeClass {
    constructor($timeout, resolveIt = true) {
        this.$timeout = $timeout;
        this.resolveIt = resolveIt;
        this.thenPerformed = false;
        this.catchPerformed = false;
        this.finallyPerformed = false;
        this.value = new Promise((resolve, reject) => {
            this.$timeout(() => {
                if (this.resolveIt) {
                    resolve(() => true);
                }
                else {
                    reject();
                }
            }, 100);
        });
    }
    catch(func) {
        let catchFunc = (data) => {
            this.catchPerformed = true;
            return func(data);
        };
        if (this.value) {
            this.value.catch(catchFunc);
        }
        else {
            this.fCatch = catchFunc;
        }
        return this;
    }
    finally(func) {
        let finallyFunc = () => {
            this.finallyPerformed = true;
            func();
        };
        if (this.value) {
            this.value.finally(finallyFunc);
        }
        else {
            this.fFinally = finallyFunc;
        }
        return this;
    }
    start() {
        //starts the process
        if (this.fCatch) {
            this.value.catch(this.fCatch);
        }
        if (this.fThen) {
            this.value.then(this.fThen);
        }
        if (this.fFinally) {
            this.value.finally(this.fFinally);
        }
    }
    cancel() {
        //TODO do something with it
    }
    then(func) {
        let thenFunc = (data) => {
            this.thenPerformed = true;
            return func(data);
        };
        if (this.value) {
            this.value.then(thenFunc);
        }
        else {
            this.fThen = thenFunc;
        }
        return this;
    }
}
exports.ProbeClass = ProbeClass;
//# sourceMappingURL=AsynchronousProbe.js.map