<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>4.0.0</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-api</artifactId>
    <name>Apache MyFaces Core 4.0 - API</name>
    <description>
        The public API classes of the Apache MyFaces Core JSF-4.0 project
    </description>
    <url>https://myfaces.apache.org/#/core40</url>

    <build>
        <resources>
            <!-- standard resources -->
            <resource>
                <directory>src/main/resources</directory>
            </resource>
        </resources>

        <plugins>
            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>build-helper-maven-plugin</artifactId>
                <executions>
                  <execution>
                    <id>parse-version</id>
                    <goals>
                      <goal>parse-version</goal>
                    </goals>
                  </execution>
                </executions>
            </plugin>

            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-checkstyle-plugin</artifactId>
                <configuration>
                    <excludes>jakarta/faces/component/**/*.java</excludes>
                </configuration>
            </plugin>


            <!-- we want to use the test cases also in myfacse-impl, thus creating a test-jar -->
            <plugin>
                <artifactId>maven-jar-plugin</artifactId>
                <version>2.2</version>
                <executions>
                    <execution>
                        <goals>
                            <goal>jar</goal>
                            <goal>test-jar</goal>
                        </goals>
                    </execution>
                </executions>
                <configuration>
                    <archive>
                        <manifestFile>${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>
                    </archive>
                    <excludes>
                        <exclude>**/META-INF/resources/myfaces/myfaces/**</exclude>
                        <exclude>**/META-INF/resources/jakarta.faces/myfaces/**</exclude>
                    </excludes>
                </configuration>
            </plugin>

            <!--
                berlios jsunit under apache2 license to cover javascript core routines which
                do not have to rely on a browser or can work on browser mockups!

                for furhter on dom testing we probably have to integrate html based tests
                with a browser engine but for the core apis this should be sufficient
            -->
            <plugin>
                <groupId>de.berlios.jsunit</groupId>
                <artifactId>jsunit-maven2-plugin</artifactId>
                <version>1.3</version>
                <executions>
                    <!-- TODO currently deactivated -->
                    <!--execution>
                        <id>test</id>
                        <goals>
                            <goal>jsunit-test</goal>
                        </goals>
                    </execution-->
                </executions>
                <configuration>
                    <sourceDirectory>src/main/javascript/META-INF/resources</sourceDirectory>
                    <sources>
                        <source>../../../../test/javascript/org/apache/myfaces/mockups/BrowserMockups.js</source>
                        <source>jakarta/faces/_util/_FacesUtils.js</source>
                        <source>jakarta/faces/ajax/Ajax.js</source>
                        <source>../../../../test/javascript/org/apache/myfaces/test/_TestScenario.js</source>
                    </sources>
                    <testSourceDirectory>src/test/javascript/org/apache/myfaces</testSourceDirectory>
                    <reportsDirectory>target/surefire-reports</reportsDirectory>
                    <testSuites>
                        <testSuite>
                            <name>jakarta.faces.Ajax</name>
                            <type>TESTSUITES</type>
                            <includes>
                                <include>test/MockupTest.js</include>
                                <include>utils/_FacesUtilsTests.js</include>
                                <include>ajax/AjaxTests.js</include>
                            </includes>
                        </testSuite>
                    </testSuites>
                </configuration>
            </plugin>

            <!-- myfaces-builder-plugin for metadata and component classes -->
            <plugin>
                <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-builder-plugin</artifactId>
                <executions>
                    <execution>
                        <goals>
                            <goal>build-metadata</goal>
                        </goals>
                    </execution>
                    <execution>
                        <id>makecomp</id>
                        <configuration>
                            <jsfVersion>20</jsfVersion>
                            <templateComponentName>componentClass20.vm</templateComponentName>
                        </configuration>
                        <goals>
                            <goal>make-components</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>

            <!-- create manifest.mf for OSGi -->
            <plugin>
                <groupId>org.apache.felix</groupId>
                <artifactId>maven-bundle-plugin</artifactId>
                <executions>
                    <execution>
                        <id>bundle-manifest</id>
                        <phase>process-classes</phase>
                        <goals>
                            <goal>manifest</goal>
                        </goals>
                        <configuration>
                            <instructions>
                                <Bundle-SymbolicName>org.apache.myfaces.core.api</Bundle-SymbolicName>
                                <Bundle-Classpath>.</Bundle-Classpath>
                                <Build-Jdk>${java.version}</Build-Jdk>
                                <Implementation-Title>${project.name}</Implementation-Title>
                                <Implementation-Version>${project.version}</Implementation-Version>
                                <Implementation-Vendor>The Apache Software Foundation</Implementation-Vendor>
                                <Implementation-Vendor-Id>${project.groupId}</Implementation-Vendor-Id>
                                <Export-Package>
                                    *;version="${project.version}"
                                </Export-Package>
                                <Import-Package>
                                    jakarta.el;version="[5.0.0, 6.0.0)",
                                    jakarta.validation*;version="[3.0.0, 4.0.0)",
                                    jakarta.servlet;version="[6.0.0, 7.0.0)",
                                    jakarta.servlet.http;version="[6.0.0, 7.0.0)",
                                    jakarta.faces.*;version="${project.version}"
                                </Import-Package>
                                <Require-Bundle>
                                    org.apache.myfaces.core.impl;bundle-version="${parsedVersion.osgiVersion}"
                                </Require-Bundle>
                            </instructions>
                        </configuration>
                    </execution>
                </executions>
            </plugin>

            <!-- execute tests (JUnit) -->
            <plugin>
                <artifactId>maven-surefire-plugin</artifactId>
            </plugin>

            <plugin>
                <groupId>org.apache.rat</groupId>
                <artifactId>apache-rat-plugin</artifactId>
                <configuration>
                    <excludes>
                        <exclude>**/README.md</exclude>
                        <exclude>**/*/MANIFEST.MF</exclude>
                        <exclude>**/*.iml</exclude>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.txt</exclude>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.TXT</exclude>
                        <exclude>src/main/resources/META-INF/services/**</exclude>
                        <exclude>.git</exclude>
                        <exclude>.gitignore</exclude>
                        <exclude>**/target/**/*</exclude>
                        <exclude>**/dist/**/*</exclude>
                        <!-- node modules is only used by the build -->
                        <exclude>**/node_modules/**/*</exclude>
                        <exclude>**/client/**/*.md</exclude>
                        <exclude>**/client/package*.json</exclude>
                        <exclude>**/client/**/*.js.map</exclude>
                        <exclude>**/client/typescript/**/*.js</exclude>
                        <exclude>**/client/**/.mocharc.json</exclude>

                        <exclude>src/client/webpack.config.js</exclude>
                        <exclude>DEPENDENCIES</exclude>
                    </excludes>
                </configuration>
                <executions>
                    <execution>
                        <phase>verify</phase>
                        <goals>
                            <goal>check</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>
            <plugin>
                <groupId>com.github.eirslett</groupId>
                <artifactId>frontend-maven-plugin</artifactId>
                <version>1.12.1</version>
                <!-- Use the latest released version:
                https://repo1.maven.org/maven2/com/github/eirslett/frontend-maven-plugin/ -->
                <configuration>
                    <nodeVersion>v16.13.1</nodeVersion>
                    <npmVersion>8.1.2</npmVersion>
                    <installDirectory>./target/node</installDirectory>
                    <workingDirectory>src/client</workingDirectory>
                </configuration>
                <executions>
                    <execution>
                        <id>install node and npm</id>
                        <goals>
                            <goal>install-node-and-npm</goal>
                        </goals>
                        <phase>generate-resources</phase>
                    </execution>
                    <execution>
                        <id>npm install</id>
                        <phase>generate-resources</phase>
                        <goals>
                            <goal>npm</goal>
                        </goals>
                        <configuration>
                            <arguments>install</arguments>
                        </configuration>
                    </execution>
                    <execution>
                        <id>npm run build</id>
                        <goals>
                            <goal>npm</goal>
                        </goals>
                        <phase>generate-resources</phase>
                        <configuration>
                            <arguments>run build</arguments>
                        </configuration>
                    </execution>
                    <execution>
                        <id>npm run test</id>
                        <goals>
                            <goal>npm</goal>
                        </goals>
                        <phase>test</phase>
                        <configuration>
                            <arguments>run test</arguments>
                        </configuration>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>


    <profiles>

        <!-- TODO jakobk: we could change this to -Papache-release -->
        <!--
        - Generate files that are good to have when doing a release to main
        - repositories, but which are not wanted when doing a quick
        - "mvn install" before testing some code modifications.
        -->
        <profile>
            <id>generate-assembly</id>
            <build>
                <plugins>
                    <plugin>
                        <groupId>org.apache.maven.plugins</groupId>
                        <artifactId>maven-javadoc-plugin</artifactId>
                        <configuration>
                        </configuration>
                        <executions>
                            <execution>
                                <id>attach-javadoc</id>
                                <goals>
                                    <goal>jar</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>

        <!-- This profile verifies the binary compablity with the jsf api of the RI -->
        <profile>
            <id>checkCompatibility</id>
            <build>
                <plugins>
                    <plugin>
                        <groupId>org.codehaus.mojo</groupId>
                        <artifactId>clirr-maven-plugin</artifactId>
                        <version>2.8</version>
                        <configuration>
                            <comparisonArtifacts>
                                <comparisonArtifact>
                                    <groupId>org.glassfish</groupId>
                                    <artifactId>jakarta.faces</artifactId>
                                    <version>4.0.0</version>
                                </comparisonArtifact>
                            </comparisonArtifacts>
                            <includes>
                                <include>jakarta/faces/**</include>
                            </includes>
                        </configuration>
                        <executions>
                            <execution>
                                <goals>
                                    <goal>check</goal>
                                </goals>
                                <phase>test</phase>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>

        <!-- check for Java 1.6 -->
        <profile>
            <id>checkJDK</id>
            <activation>
                <property>
                    <name>performRelease</name>
                    <value>true</value>
                </property>
            </activation>
            <build>
                <plugins>
                </plugins>
            </build>
        </profile>

        <!--
            this optional profile generates the jsdoc content from
            the embedded javascripts
        -->

        <profile>
            <id>generateJsDoc</id>
            <build>
              <plugins>
                  <plugin>
                      <groupId>com.github.eirslett</groupId>
                      <artifactId>frontend-maven-plugin</artifactId>
                      <version>1.12.1</version>
                      <!-- Use the latest released version:
                      https://repo1.maven.org/maven2/com/github/eirslett/frontend-maven-plugin/ -->
                      <configuration>
                          <nodeVersion>v16.13.1</nodeVersion>
                          <npmVersion>8.1.2</npmVersion>
                          <installDirectory>./target/node</installDirectory>
                          <workingDirectory>src/client</workingDirectory>
                      </configuration>
                      <executions>
                          <execution>
                              <id>install node and npm</id>
                              <goals>
                                  <goal>install-node-and-npm</goal>
                              </goals>
                              <phase>generate-resources</phase>
                          </execution>

                          <execution>
                              <id>npm run build</id>
                              <goals>
                                  <goal>npm</goal>
                              </goals>
                              <phase>generate-resources</phase>
                              <configuration>
                                  <arguments>run doc</arguments>
                              </configuration>
                          </execution>
                      </executions>
                  </plugin>
               </plugins>
            </build>
        </profile>

    </profiles>


    <dependencies>
        <!-- Java EE APIs -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-websocket-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-el-api</artifactId>
        </dependency>
        <dependency>
            <groupId>jakarta.validation</groupId>
            <artifactId>jakarta.validation-api</artifactId>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jcdi_2.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-atinject_1.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>


        <!-- builder-annotations like @JSFWebConfigParam -->
        <dependency>
            <groupId>org.apache.myfaces.buildtools</groupId>
            <artifactId>myfaces-builder-annotations</artifactId>
        </dependency>

        <dependency>
            <groupId>de.berlios.jsunit</groupId>
            <artifactId>jsunit-maven2-plugin</artifactId>
        </dependency>
    </dependencies>


    <reporting>
        <plugins>
            <plugin>
                <artifactId>maven-javadoc-plugin</artifactId>
                <configuration>
                    <tags>
                        <tag>
                            <name>JSFJspTag</name>
                            <placement>X</placement>
                        </tag>
                        <tag>
                            <name>JSFJspAttribute</name>
                            <placement>X</placement>
                        </tag>
                    </tags>
                </configuration>
            </plugin>

            <plugin>
               <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-jsdoc-plugin</artifactId>
                <version>1.0-beta-1</version>
            </plugin>

            <plugin>
                <artifactId>maven-changelog-plugin</artifactId>
                <reportSets>
                    <reportSet>
                        <id>dual-report</id>
                        <configuration>
                            <type>range</type>
                            <range>30</range>
                        </configuration>
                        <reports>
                            <report>changelog</report>
                            <report>file-activity</report>
                            <report>dev-activity</report>
                        </reports>
                    </reportSet>
                </reportSets>
            </plugin>

            <plugin>
                <artifactId>maven-jxr-plugin</artifactId>
            </plugin>

            <plugin>
                <artifactId>maven-surefire-report-plugin</artifactId>
            </plugin>

            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>taglist-maven-plugin</artifactId>
            </plugin>
        </plugins>
    </reporting>

</project>
