"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const mona_dish_1 = require("mona-dish");
var defaultFileForm = StandardInits_1.StandardInits.defaultFileForm;
const AjaxImpl_1 = require("../../impl/AjaxImpl");
/**
 * specialized tests testing the xhr core behavior when it hits the xmlHttpRequest object
 */
(0, mocha_1.describe)('Tests on the xhr core when it starts to call the request', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultFileForm();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.respond = (response) => {
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/xml";
                    xhrReq.respond(200, { 'Content-Type': 'text/xml' }, response);
                    return xhrReq;
                };
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('must have sent a form multipart request', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        const CONTENT_TYPE = "Content-Type";
        const POST = "POST";
        global["debug_f"] = true;
        try {
            let button = mona_dish_1.DomQuery.byId("input_1");
            button.addEventListener("click", (event) => {
                faces.ajax.request(event.target, event, { render: '@all', execute: '@form' });
            }).click();
            //this.resonse("ok");
            (0, chai_1.expect)(this.requests.length).to.eq(1);
            let request = this.requests[0];
            (0, chai_1.expect)(request.method).to.eq(POST);
            (0, chai_1.expect)(request.async).to.be.true;
            (0, chai_1.expect)(send.called).to.be.true;
            (0, chai_1.expect)(send.callCount).to.eq(1);
            (0, chai_1.expect)(request.requestBody instanceof FormData).to.be.true;
            (0, chai_1.expect)(request.requestHeaders[CONTENT_TYPE] == undefined).to.be.true;
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('must have sent a multipart request with a dedicated execute', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        const CONTENT_TYPE = "Content-Type";
        const POST = "POST";
        try {
            let button = mona_dish_1.DomQuery.byId("input_1");
            button.addEventListener("click", (event) => {
                faces.ajax.request(event.target, event, { render: '@all', execute: 'input_1 fíleupload' });
            }).click();
            //this.resonse("ok");
            (0, chai_1.expect)(this.requests.length).to.eq(1);
            let request = this.requests[0];
            (0, chai_1.expect)(request.method).to.eq(POST);
            (0, chai_1.expect)(request.async).to.be.true;
            (0, chai_1.expect)(send.called).to.be.true;
            (0, chai_1.expect)(send.callCount).to.eq(1);
            (0, chai_1.expect)(request.requestBody instanceof FormData).to.be.true;
            //undefined means the browser fills in the rest
            (0, chai_1.expect)(request.requestHeaders[CONTENT_TYPE] == undefined).to.be.true;
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('must have sent a single part request with a dedicated execute', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        const CONTENT_TYPE = "Content-Type";
        const MULTIPART_FORM = "multipart/form-data";
        const POST = "POST";
        try {
            let button = mona_dish_1.DomQuery.byId("input_1");
            button.addEventListener("click", (event) => {
                faces.ajax.request(event.target, event, { render: '@all', execute: '@none' });
            }).click();
            (0, chai_1.expect)(this.requests.length).to.eq(1);
            let request = this.requests[0];
            (0, chai_1.expect)(request.method).to.eq(POST);
            (0, chai_1.expect)(request.async).to.be.true;
            (0, chai_1.expect)(send.called).to.be.true;
            (0, chai_1.expect)(send.callCount).to.eq(1);
            (0, chai_1.expect)(request.requestBody instanceof FormData).to.be.false;
            (0, chai_1.expect)(request.requestHeaders[CONTENT_TYPE].indexOf(MULTIPART_FORM) == -1).to.be.true;
        }
        finally {
            send.restore();
        }
        done();
    });
});
//# sourceMappingURL=FileUploadTest.spec.js.map