/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;

public class _DateRestrictionRule extends MetaRule
{
    final static class DateRestrictionMetadata extends Metadata {

        private final String name;

        private final TagAttribute attr;

        private final Method method;
        
        private final Class type;
        
        private Object[] value;

        public DateRestrictionMetadata(String name, Method method, Class type,
                TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.method = method;
            this.type = type;
        }
        
        @Override
        public void applyMetadata(FaceletContext ctx, Object instance)
        {
            if (this.attr.isLiteral())
            {
                try
                {
                    if (value == null) {
                        value = new Object[] { 
                                org.apache.myfaces.commons.util.TagUtils.getStringArray(
                                        ctx.getExpressionFactory().coerceToType(
                                                this.attr.getValue(), 
                                                String.class)
                                ) };
                    }
                    try {
                        method.invoke(instance, this.value);
                    } catch (InvocationTargetException e) {
                        throw new TagAttributeException(this.attr, e.getCause());
                    } catch (Exception e) {
                        throw new TagAttributeException(this.attr, e);
                    }
                }
                catch(ParseException e)
                {
                    throw new TagAttributeException(this.attr, e);
                }
            }
            else
            {
                ((ValidatorBase) instance).setValueExpression(this.name, this.attr
                        .getValueExpression(ctx, this.type));
            }
        }
        
    }
    
    public final static _DateRestrictionRule Instance = new _DateRestrictionRule();
    
    public _DateRestrictionRule()
    {
        super();
    }

    @Override
    public Metadata applyRule(String name, TagAttribute attribute,
            MetadataTarget meta)
    {
        if (meta.isTargetInstanceOf(DateRestrictionValidator.class)) {
            
            if ("invalidMonths".equals(name) || "invalidDaysOfWeek".equals(name))
            {
                Method m = meta.getWriteMethod(name);
                Class type = meta.getPropertyType(name);
                if (type == null) {
                    type = Object.class;
                }
                return new DateRestrictionMetadata(name, m, type, attribute);
            }
        }
        return null;
    }

}

