/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.DataConnectionException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.util.SocketAddressEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASV
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(PASV.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        ServerDataConnectionFactory dataCon = session.getDataConnection();
        String externalPassiveAddress = this.getPassiveExternalAddress(session);
        try {
            InetSocketAddress dataConAddress = dataCon.initPassiveDataConnection();
            InetAddress servAddr = externalPassiveAddress != null ? this.resolveAddress(externalPassiveAddress) : dataConAddress.getAddress();
            InetSocketAddress externalDataConAddress = new InetSocketAddress(servAddr, dataConAddress.getPort());
            String addrStr = SocketAddressEncoder.encode(externalDataConAddress);
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 227, "PASV", addrStr));
        }
        catch (DataConnectionException e) {
            this.LOG.warn("Failed to open passive data connection", (Throwable)((Object)e));
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 425, "PASV", null));
            return;
        }
    }

    private InetAddress resolveAddress(String host) throws DataConnectionException {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new DataConnectionException(ex.getLocalizedMessage(), ex);
        }
    }

    protected String getPassiveExternalAddress(FtpIoSession session) {
        return session.getListener().getDataConnectionConfiguration().getPassiveExernalAddress();
    }
}

