/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.DocumentVersionImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FilingImpl;

public class VersionedDocumentImpl
extends FilingImpl
implements VersionedDocument {
    private boolean fIsCheckedOut = false;
    private String fCheckedOutUser;
    private final List<DocumentVersion> fVersions = new ArrayList<DocumentVersion>();

    @Override
    public DocumentVersion addVersion(VersioningState verState, String user) {
        if (this.isCheckedOut()) {
            throw new CmisConstraintException("Cannot add a version to document, document is checked out.");
        }
        DocumentVersionImpl ver = new DocumentVersionImpl(this.fRepositoryId, this, verState);
        ver.setSystemBasePropertiesWhenCreatedDirect(this.getName(), this.getTypeId(), user);
        this.fVersions.add(ver);
        if (verState == VersioningState.CHECKEDOUT) {
            this.fCheckedOutUser = user;
            this.fIsCheckedOut = true;
        }
        return ver;
    }

    @Override
    public boolean deleteVersion(DocumentVersion version) {
        DocumentVersion pwc;
        if (this.fIsCheckedOut && (pwc = this.getPwc()) == version) {
            this.cancelCheckOut(false);
            return !this.fVersions.isEmpty();
        }
        boolean found = this.fVersions.remove(version);
        if (!found) {
            throw new CmisInvalidArgumentException("Version is not contained in the document:" + version.getId());
        }
        return !this.fVersions.isEmpty();
    }

    @Override
    public void cancelCheckOut(String user) {
        this.cancelCheckOut(true);
    }

    @Override
    public void checkIn(boolean isMajor, Properties properties, ContentStream content, String checkinComment, List<String> policyIds, String user) {
        if (this.fIsCheckedOut) {
            if (!this.fCheckedOutUser.equals(user)) {
                throw new CmisConstraintException("Error: Can't checkin. Document " + this.getId() + " user " + user + " has not checked out the document");
            }
        } else {
            throw new CmisConstraintException("Error: Can't cancel checkout, Document " + this.getId() + " is not checked out.");
        }
        this.fIsCheckedOut = false;
        this.fCheckedOutUser = null;
        DocumentVersion pwc = this.getPwc();
        if (null != content) {
            pwc.setContent(content);
        }
        if (null != properties && null != properties.getProperties()) {
            ((DocumentVersionImpl)pwc).setCustomProperties(properties.getProperties());
        }
        pwc.setCheckinComment(checkinComment);
        pwc.commit(isMajor);
        if (policyIds != null && policyIds.size() > 0) {
            ((DocumentVersionImpl)pwc).setAppliedPolicies(policyIds);
        }
    }

    @Override
    public DocumentVersion checkOut(String user) {
        if (this.fIsCheckedOut) {
            throw new CmisConstraintException("Error: Can't checkout, Document " + this.getId() + " is already checked out.");
        }
        DocumentVersion pwc = this.addVersion(VersioningState.CHECKEDOUT, user);
        return pwc;
    }

    @Override
    public List<DocumentVersion> getAllVersions() {
        return this.fVersions;
    }

    @Override
    public DocumentVersion getLatestVersion(boolean major) {
        DocumentVersion latest = null;
        if (this.fVersions.size() == 0) {
            return null;
        }
        if (major) {
            for (DocumentVersion ver : this.fVersions) {
                if (!ver.isMajor() || ver.isPwc()) continue;
                latest = ver;
            }
        } else {
            latest = null == this.getPwc() ? this.fVersions.get(this.fVersions.size() - 1) : (this.fVersions.size() > 1 ? this.fVersions.get(this.fVersions.size() - 2) : null);
            latest = null == this.getPwc() ? this.fVersions.get(this.fVersions.size() - 1) : (this.fVersions.size() > 1 ? this.fVersions.get(this.fVersions.size() - 2) : null);
        }
        return latest;
    }

    @Override
    public boolean isCheckedOut() {
        return this.fIsCheckedOut;
    }

    @Override
    public String getCheckedOutBy() {
        return this.fCheckedOutUser;
    }

    @Override
    public DocumentVersion getPwc() {
        for (DocumentVersion ver : this.fVersions) {
            if (!ver.isPwc()) continue;
            return ver;
        }
        return null;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        DocumentVersion pwc = this.getPwc();
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:isImmutable", requestedIds)) {
            properties.put("cmis:isImmutable", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isImmutable", Boolean.valueOf(false)));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesId", requestedIds)) {
            properties.put("cmis:versionSeriesId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesId", this.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:isVersionSeriesCheckedOut", requestedIds)) {
            properties.put("cmis:isVersionSeriesCheckedOut", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(this.isCheckedOut())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutBy", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", this.getCheckedOutBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutId", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesCheckedOutId", pwc == null ? null : pwc.getId()));
        }
    }

    private void cancelCheckOut(boolean deleteInObjectStore) {
        DocumentVersion pwc = this.getPwc();
        this.fIsCheckedOut = false;
        this.fCheckedOutUser = null;
        this.fVersions.remove(pwc);
        if (this.fVersions.size() > 0) {
            String nameLatestVer = this.getLatestVersion(false).getName();
            if (!this.getName().equals(nameLatestVer)) {
                this.setName(nameLatestVer);
            }
        }
        if (deleteInObjectStore) {
            // empty if block
        }
    }
}

