/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.heif.HeifDirectory;
import com.drew.metadata.heif.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;

public class FileTypeBox
extends Box {
    String majorBrand;
    long minorVersion;
    ArrayList<String> compatibleBrands;

    public FileTypeBox(SequentialReader reader, Box box) throws IOException {
        super(box);
        this.majorBrand = reader.getString(4);
        this.minorVersion = reader.getUInt32();
        this.compatibleBrands = new ArrayList();
        int i = 16;
        while ((long)i < this.size) {
            this.compatibleBrands.add(reader.getString(4));
            i += 4;
        }
    }

    public void addMetadata(HeifDirectory directory) {
        directory.setString(1, this.majorBrand);
        directory.setLong(2, this.minorVersion);
        directory.setStringArray(3, this.compatibleBrands.toArray(new String[this.compatibleBrands.size()]));
    }

    public ArrayList<String> getCompatibleBrands() {
        return this.compatibleBrands;
    }
}

