/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractActionWithNoRunningTest;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;

@AutoService(value={Command.class})
public class ExitCommand
extends AbstractActionWithNoRunningTest {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (guiPackage.isDirty()) {
            int chosenOption = JOptionPane.showConfirmDialog(guiPackage.getMainFrame(), JMeterUtils.getResString("cancel_exit_to_save"), JMeterUtils.getResString("save?"), 1, 3);
            if (chosenOption == 1) {
                System.exit(0);
            } else if (chosenOption == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
                if (!guiPackage.isDirty()) {
                    System.exit(0);
                }
            }
        } else {
            System.exit(0);
        }
    }

    static {
        commands.add("exit");
    }
}

