/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.influxdb;

import com.google.auto.service.AutoService;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.ErrorMetric;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.UserMetric;
import org.apache.jmeter.visualizers.backend.influxdb.AbstractInfluxdbMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.HttpMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BackendListenerClient.class})
public class InfluxdbBackendListenerClient
extends AbstractBackendListenerClient
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(InfluxdbBackendListenerClient.class);
    private final ConcurrentHashMap<String, SamplerMetric> metricsPerSampler = new ConcurrentHashMap();
    private static final String EVENTS_FOR_ANNOTATION = "events";
    private static final String TAGS = ",tags=";
    private static final String TEXT = "text=\"";
    private static final String DEFAULT_MEASUREMENT = "jmeter";
    private static final String TAG_TRANSACTION = ",transaction=";
    private static final String TAG_STATUS = ",statut=";
    private static final String TAG_APPLICATION = ",application=";
    private static final String TAG_RESPONSE_CODE = ",responseCode=";
    private static final String TAG_RESPONSE_MESSAGE = ",responseMessage=";
    private static final String METRIC_COUNT = "count=";
    private static final String METRIC_COUNT_ERROR = "countError=";
    private static final String METRIC_MIN = "min=";
    private static final String METRIC_MAX = "max=";
    private static final String METRIC_AVG = "avg=";
    private static final String METRIC_HIT = "hit=";
    private static final String METRIC_SENT_BYTES = "sb=";
    private static final String METRIC_RECEIVED_BYTES = "rb=";
    private static final String METRIC_PCT_PREFIX = "pct";
    private static final String METRIC_MAX_ACTIVE_THREADS = "maxAT=";
    private static final String METRIC_MIN_ACTIVE_THREADS = "minAT=";
    private static final String METRIC_MEAN_ACTIVE_THREADS = "meanAT=";
    private static final String METRIC_STARTED_THREADS = "startedT=";
    private static final String METRIC_ENDED_THREADS = "endedT=";
    private static final String TAG_OK = "ok";
    private static final String TAG_KO = "ko";
    private static final String TAG_ALL = "all";
    private static final String CUMULATED_METRICS = "all";
    private static final long SEND_INTERVAL = JMeterUtils.getPropDefault((String)"backend_influxdb.send_interval", (int)5);
    private static final int MAX_POOL_SIZE = 1;
    private static final String SEPARATOR = ";";
    private static final Object LOCK = new Object();
    private static final Map<String, String> DEFAULT_ARGS = new LinkedHashMap<String, String>();
    private boolean summaryOnly;
    private String measurement = "DEFAULT_MEASUREMENT";
    private String samplersRegex = "";
    private Pattern samplersToFilter;
    private Map<String, Float> okPercentiles;
    private Map<String, Float> koPercentiles;
    private Map<String, Float> allPercentiles;
    private String testTitle;
    private String testTags;
    private String applicationName = "";
    private String userTag = "";
    private InfluxdbMetricsSender influxdbMetricsManager;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> timerHandle;

    @Override
    public void run() {
        this.sendMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMetrics() {
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<String, SamplerMetric> entry : this.metricsPerSampler.entrySet()) {
                SamplerMetric metric = entry.getValue();
                if (entry.getKey().equals("all")) {
                    this.addCumulatedMetrics(metric);
                } else {
                    this.addMetrics(AbstractInfluxdbMetricsSender.tagToStringValue(entry.getKey()), metric);
                }
                metric.resetForTimeInterval();
            }
        }
        UserMetric userMetrics = this.getUserMetrics();
        StringBuilder tag = new StringBuilder(80);
        tag.append(TAG_APPLICATION).append(this.applicationName);
        tag.append(TAG_TRANSACTION).append("internal");
        tag.append(this.userTag);
        StringBuilder field = new StringBuilder(80);
        field.append(METRIC_MIN_ACTIVE_THREADS).append(userMetrics.getMinActiveThreads()).append(',');
        field.append(METRIC_MAX_ACTIVE_THREADS).append(userMetrics.getMaxActiveThreads()).append(',');
        field.append(METRIC_MEAN_ACTIVE_THREADS).append(userMetrics.getMeanActiveThreads()).append(',');
        field.append(METRIC_STARTED_THREADS).append(userMetrics.getStartedThreads()).append(',');
        field.append(METRIC_ENDED_THREADS).append(userMetrics.getFinishedThreads());
        this.influxdbMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
        this.influxdbMetricsManager.writeAndSendMetrics();
    }

    private void addMetrics(String transaction, SamplerMetric metric) {
        this.addMetric(transaction, metric.getTotal(), metric.getSentBytes(), metric.getReceivedBytes(), "all", metric.getAllMean(), metric.getAllMinTime(), metric.getAllMaxTime(), metric.getHits(), this.allPercentiles.values(), metric::getAllPercentile);
        this.addMetric(transaction, metric.getSuccesses(), metric.getSentBytes(), metric.getReceivedBytes(), TAG_OK, metric.getOkMean(), metric.getOkMinTime(), metric.getOkMaxTime(), metric.getHits(), this.okPercentiles.values(), metric::getOkPercentile);
        this.addMetric(transaction, metric.getFailures(), metric.getSentBytes(), metric.getReceivedBytes(), TAG_KO, metric.getKoMean(), metric.getKoMinTime(), metric.getKoMaxTime(), metric.getHits(), this.koPercentiles.values(), metric::getKoPercentile);
        metric.getErrors().forEach((err, count) -> this.addErrorMetric(transaction, (ErrorMetric)err, count.intValue()));
    }

    private void addErrorMetric(String transaction, ErrorMetric err, long count) {
        if (count <= 0L) {
            return;
        }
        StringBuilder tag = new StringBuilder(70);
        tag.append(TAG_APPLICATION).append(this.applicationName);
        tag.append(TAG_TRANSACTION).append(transaction);
        tag.append(TAG_RESPONSE_CODE).append(AbstractInfluxdbMetricsSender.tagToStringValue(err.getResponseCode()));
        tag.append(TAG_RESPONSE_MESSAGE).append(AbstractInfluxdbMetricsSender.tagToStringValue(err.getResponseMessage()));
        tag.append(this.userTag);
        StringBuilder field = new StringBuilder(30);
        field.append(METRIC_COUNT).append(count);
        this.influxdbMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
    }

    private void addMetric(String transaction, int count, Long sentBytes, Long receivedBytes, String status, double mean, double minTime, double maxTime, int hits, Collection<Float> pcts, PercentileProvider percentileProvider) {
        if (count <= 0) {
            return;
        }
        StringBuilder tag = new StringBuilder(95);
        tag.append(TAG_APPLICATION).append(this.applicationName);
        tag.append(TAG_TRANSACTION).append(transaction);
        tag.append(TAG_STATUS).append(status);
        tag.append(this.userTag);
        StringBuilder field = new StringBuilder(80);
        field.append(METRIC_COUNT).append(count);
        if (!Double.isNaN(mean)) {
            field.append(',').append(METRIC_AVG).append(mean);
        }
        if (!Double.isNaN(minTime)) {
            field.append(',').append(METRIC_MIN).append(minTime);
        }
        if (!Double.isNaN(maxTime)) {
            field.append(',').append(METRIC_MAX).append(maxTime);
        }
        field.append(',').append(METRIC_HIT).append(hits);
        if (sentBytes != null) {
            field.append(',').append(METRIC_SENT_BYTES).append(sentBytes);
        }
        if (receivedBytes != null) {
            field.append(',').append(METRIC_RECEIVED_BYTES).append(receivedBytes);
        }
        for (Float pct : pcts) {
            field.append(',').append(METRIC_PCT_PREFIX).append(pct).append('=').append(percentileProvider.getPercentileValue(pct.floatValue()));
        }
        this.influxdbMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
    }

    private void addCumulatedMetrics(SamplerMetric metric) {
        int total = metric.getTotal();
        if (total <= 0) {
            return;
        }
        StringBuilder tag = new StringBuilder(70);
        StringBuilder field = new StringBuilder(100);
        Collection<Float> pcts = this.allPercentiles.values();
        tag.append(TAG_APPLICATION).append(this.applicationName);
        tag.append(TAG_TRANSACTION).append("all");
        tag.append(TAG_STATUS).append("all");
        tag.append(this.userTag);
        field.append(METRIC_COUNT).append(total);
        field.append(',').append(METRIC_COUNT_ERROR).append(metric.getFailures());
        if (!Double.isNaN(metric.getOkMean())) {
            field.append(',').append(METRIC_AVG).append(Double.toString(metric.getOkMean()));
        }
        if (!Double.isNaN(metric.getOkMinTime())) {
            field.append(',').append(METRIC_MIN).append(Double.toString(metric.getOkMinTime()));
        }
        if (!Double.isNaN(metric.getOkMaxTime())) {
            field.append(',').append(METRIC_MAX).append(Double.toString(metric.getOkMaxTime()));
        }
        field.append(',').append(METRIC_HIT).append(metric.getHits());
        field.append(',').append(METRIC_SENT_BYTES).append(metric.getSentBytes());
        field.append(',').append(METRIC_RECEIVED_BYTES).append(metric.getReceivedBytes());
        for (Float pct : pcts) {
            field.append(',').append(METRIC_PCT_PREFIX).append(pct).append('=').append(Double.toString(metric.getAllPercentile(pct.floatValue())));
        }
        this.influxdbMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
    }

    public String getSamplersRegex() {
        return this.samplersRegex;
    }

    public void setSamplersList(String samplersList) {
        this.samplersRegex = samplersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        Object object = LOCK;
        synchronized (object) {
            UserMetric userMetrics = this.getUserMetrics();
            for (SampleResult sampleResult : sampleResults) {
                userMetrics.add(sampleResult);
                Matcher matcher = this.samplersToFilter.matcher(sampleResult.getSampleLabel());
                if (!this.summaryOnly && matcher.find()) {
                    SamplerMetric samplerMetric = this.getSamplerMetricInfluxdb(sampleResult.getSampleLabel());
                    samplerMetric.add(sampleResult);
                }
                SamplerMetric cumulatedMetrics = this.getSamplerMetricInfluxdb("all");
                cumulatedMetrics.addCumulated(sampleResult);
            }
        }
    }

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        this.summaryOnly = context.getBooleanParameter("summaryOnly", false);
        this.samplersRegex = context.getParameter("samplersRegex", "");
        this.applicationName = AbstractInfluxdbMetricsSender.tagToStringValue(context.getParameter("application", ""));
        this.measurement = AbstractInfluxdbMetricsSender.tagToStringValue(context.getParameter("measurement", DEFAULT_MEASUREMENT));
        this.testTitle = context.getParameter("testTitle", "Test");
        this.testTags = AbstractInfluxdbMetricsSender.tagToStringValue(context.getParameter("eventTags", ""));
        this.initPercentiles(context);
        this.initUserTags(context);
        this.initInfluxdbMetricsManager(context);
        this.samplersToFilter = Pattern.compile(this.samplersRegex);
        this.addAnnotation(true);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.timerHandle = this.scheduler.scheduleAtFixedRate(this, 0L, SEND_INTERVAL, TimeUnit.SECONDS);
    }

    private void initInfluxdbMetricsManager(BackendListenerContext context) throws Exception {
        Class<?> clazz = Class.forName(context.getParameter("influxdbMetricsSender"));
        this.influxdbMetricsManager = (InfluxdbMetricsSender)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String influxdbUrl = context.getParameter("influxdbUrl");
        String influxdbToken = context.getParameter("influxdbToken");
        this.influxdbMetricsManager.setup(influxdbUrl, influxdbToken);
    }

    private void initUserTags(BackendListenerContext context) {
        StringBuilder userTagBuilder = new StringBuilder();
        context.getParameterNamesIterator().forEachRemaining(name -> {
            if (StringUtils.isNotBlank((CharSequence)name) && !DEFAULT_ARGS.containsKey(name.trim()) && name.startsWith("TAG_") && StringUtils.isNotBlank((CharSequence)context.getParameter((String)name))) {
                String tagName = name.trim().substring(4);
                String tagValue = context.getParameter((String)name).trim();
                userTagBuilder.append(',').append(AbstractInfluxdbMetricsSender.tagToStringValue(tagName)).append('=').append(AbstractInfluxdbMetricsSender.tagToStringValue(tagValue));
                log.debug("Adding '{}' tag with '{}' value ", (Object)tagName, (Object)tagValue);
            }
        });
        this.userTag = userTagBuilder.toString();
    }

    private void initPercentiles(BackendListenerContext context) {
        String percentilesAsString = context.getParameter("percentiles", "");
        String[] percentilesStringArray = percentilesAsString.split(SEPARATOR);
        this.okPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.koPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.allPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        DecimalFormat format = new DecimalFormat("0.##");
        for (String percentile : percentilesStringArray) {
            String trimmedPercentile = percentile.trim();
            if (StringUtils.isEmpty((CharSequence)trimmedPercentile)) continue;
            try {
                Float percentileValue = Float.valueOf(trimmedPercentile);
                String key = AbstractInfluxdbMetricsSender.tagToStringValue(format.format(percentileValue));
                this.okPercentiles.put(key, percentileValue);
                this.koPercentiles.put(key, percentileValue);
                this.allPercentiles.put(key, percentileValue);
            }
            catch (Exception e) {
                log.error("Error parsing percentile: '{}'", (Object)percentile, (Object)e);
            }
        }
    }

    private SamplerMetric getSamplerMetricInfluxdb(String sampleLabel) {
        SamplerMetric samplerMetric = this.metricsPerSampler.get(sampleLabel);
        if (samplerMetric != null) {
            return samplerMetric;
        }
        SamplerMetric newSamplerMetric = new SamplerMetric();
        SamplerMetric oldValue = this.metricsPerSampler.putIfAbsent(sampleLabel, newSamplerMetric);
        if (oldValue != null) {
            newSamplerMetric = oldValue;
        }
        return newSamplerMetric;
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        boolean cancelState = this.timerHandle.cancel(false);
        log.debug("Canceled state: {}", (Object)cancelState);
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Error waiting for end of scheduler");
            Thread.currentThread().interrupt();
        }
        this.addAnnotation(false);
        log.info("Sending last metrics to InfluxDB");
        this.sendMetrics();
        this.influxdbMetricsManager.destroy();
        super.teardownTest(context);
    }

    private void addAnnotation(boolean isStartOfTest) {
        String tags = TAG_APPLICATION + this.applicationName + ",title=ApacheJMeter" + this.userTag + (StringUtils.isNotEmpty((CharSequence)this.testTags) ? TAGS + this.testTags : "");
        String field = TEXT + AbstractInfluxdbMetricsSender.fieldToStringValue(this.testTitle + (isStartOfTest ? " started" : " ended")) + "\"";
        this.influxdbMetricsManager.addMetric(EVENTS_FOR_ANNOTATION, tags, field);
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        DEFAULT_ARGS.forEach((arg_0, arg_1) -> ((Arguments)arguments).addArgument(arg_0, arg_1));
        return arguments;
    }

    static {
        DEFAULT_ARGS.put("influxdbMetricsSender", HttpMetricsSender.class.getName());
        DEFAULT_ARGS.put("influxdbUrl", "http://host_to_change:8086/write?db=jmeter");
        DEFAULT_ARGS.put("application", "application name");
        DEFAULT_ARGS.put("measurement", DEFAULT_MEASUREMENT);
        DEFAULT_ARGS.put("summaryOnly", "false");
        DEFAULT_ARGS.put("samplersRegex", ".*");
        DEFAULT_ARGS.put("percentiles", "99;95;90");
        DEFAULT_ARGS.put("testTitle", "Test name");
        DEFAULT_ARGS.put("eventTags", "");
    }

    @FunctionalInterface
    private static interface PercentileProvider {
        public double getPercentileValue(double var1);
    }
}

