/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.UserMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackendListenerClient
implements BackendListenerClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractBackendListenerClient.class);
    private final UserMetric userMetrics = new UserMetric();
    private final ConcurrentHashMap<String, SamplerMetric> metricsPerSampler = new ConcurrentHashMap();

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{}: setupTest", (Object)this.getClass().getName());
        }
        this.metricsPerSampler.clear();
        this.userMetrics.clear();
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{}: teardownTest", (Object)this.getClass().getName());
        }
        this.metricsPerSampler.clear();
        this.userMetrics.clear();
    }

    @Override
    public Arguments getDefaultParameters() {
        return null;
    }

    protected Logger getNewLogger() {
        return log;
    }

    protected final SamplerMetric getSamplerMetric(String sampleLabel) {
        SamplerMetric oldValue;
        SamplerMetric samplerMetric = this.metricsPerSampler.get(sampleLabel);
        if (samplerMetric == null && (oldValue = this.metricsPerSampler.putIfAbsent(sampleLabel, samplerMetric = new SamplerMetric())) != null) {
            samplerMetric = oldValue;
        }
        return samplerMetric;
    }

    protected Map<String, SamplerMetric> getMetricsPerSampler() {
        return this.metricsPerSampler;
    }

    protected UserMetric getUserMetrics() {
        return this.userMetrics;
    }
}

