/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.tree.TreeRendererSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

public class TreeRendererComponent
extends Container {
    private static final int PAD = 5;
    private TreeRendererSupport defaultRenderer;
    private Component renderComponent;

    public TreeRendererComponent() {
        this.setLayout(null);
        this.setVisible(true);
    }

    public void setRenderer(TreeRendererSupport renderer) {
        this.defaultRenderer = renderer;
    }

    public void setRenderComponent(Component renderComponent) {
        this.removeAll();
        this.renderComponent = renderComponent;
        this.add(renderComponent);
    }

    public Component getRenderComponent() {
        return this.renderComponent;
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public void doLayout() {
        if (this.renderComponent != null) {
            int offset = this.getOffset();
            int width = Math.min(this.renderComponent.getPreferredSize().width, this.getWidth());
            int height = this.getHeight();
            if (this.getComponentOrientation().isLeftToRight()) {
                this.renderComponent.setBounds(offset, 0, width, height);
            } else {
                this.renderComponent.setBounds(this.getWidth() - width - offset, 0, width, height);
            }
            this.renderComponent.doLayout();
        }
    }

    private int getOffset() {
        Icon icon = this.defaultRenderer.getIcon();
        if (icon == null) {
            return 0;
        }
        return icon.getIconWidth() + this.defaultRenderer.getIconTextGap();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.defaultRenderer != null) {
            Dimension actualRendererPreferredSize = this.renderComponent.getPreferredSize();
            Dimension rendererSize = this.defaultRenderer.getPreferredSize();
            this.addIconSize(actualRendererPreferredSize, rendererSize);
            return actualRendererPreferredSize;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.defaultRenderer != null) {
            Dimension actualRendererMinimumSize = this.renderComponent.getMinimumSize();
            Dimension renderSize = this.defaultRenderer.getMinimumSize();
            this.addIconSize(actualRendererMinimumSize, renderSize);
            return actualRendererMinimumSize;
        }
        return new Dimension(0, 0);
    }

    private void addIconSize(Dimension actualSize, Dimension rendererSize) {
        Icon icon = this.defaultRenderer.getIcon();
        if (icon != null) {
            actualSize.width += this.getOffset() + 5;
        }
        if (rendererSize != null) {
            actualSize.height = Math.max(actualSize.height, rendererSize.height);
        }
        if (icon != null) {
            actualSize.height = Math.max(actualSize.height, icon.getIconHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int width = this.getWidth();
        Icon icon = this.defaultRenderer.getIcon();
        if (icon != null) {
            int yLoc = this.calculateIconY(icon);
            if (this.getComponentOrientation().isLeftToRight()) {
                icon.paintIcon(this, g, 0, yLoc);
            } else {
                icon.paintIcon(this, g, width - icon.getIconWidth(), yLoc);
            }
        }
        if (this.renderComponent != null) {
            Graphics gg = g.create();
            gg.translate(this.getOffset(), 0);
            this.renderComponent.paint(gg);
            gg.dispose();
        }
    }

    private int calculateIconY(Icon icon) {
        int iconHeight = icon.getIconHeight();
        int textHeight = this.renderComponent.getFontMetrics(this.renderComponent.getFont()).getHeight();
        int textY = iconHeight / 2 - textHeight / 2;
        int totalY = Math.min(0, textY);
        int totalHeight = Math.max(iconHeight, textY + textHeight) - totalY;
        return this.getHeight() / 2 - (totalY + totalHeight / 2);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.renderComponent != null) {
            this.renderComponent.setFont(f);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.renderComponent != null) {
            this.renderComponent.setForeground(c);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.renderComponent != null) {
            this.renderComponent.setBackground(c);
        }
    }
}

