/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Factory;

public abstract class InstantMatchers {
    public static TemporalMatcher<Instant> after(Instant date) {
        return new IsAfter<Instant, Instant>(TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    public static TemporalMatcher<Instant> after(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.after(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> before(Instant date) {
        return new IsBefore<Instant, Instant>(TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    public static TemporalMatcher<Instant> before(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.before(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> sameDay(Instant date) {
        return new IsSameDay<Instant>(TemporalConverters.INSTANT_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<Instant> isDay(LocalDate date) {
        return new IsSameDay<Instant>(TemporalConverters.INSTANT_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<Instant> isDay(int year, Month month, int dayOfMonth) {
        return InstantMatchers.isDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<Instant> isDay(int year, Month month, int dayOfMonth, ZoneId zone) {
        return InstantMatchers.isDay(LocalDate.of(year, month, dayOfMonth)).atZone(zone);
    }

    public static TemporalMatcher<Instant> sameInstant(Instant date) {
        return new IsSame<Instant, Instant>(TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    public static TemporalMatcher<Instant> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.sameInstant(ZonedDateTime.of(year, month.getValue(), dayOfMonth, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> sameOrBefore(Instant date) {
        return new IsSameOrBefore<Instant, Instant>(TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    @Factory
    public static TemporalMatcher<Instant> sameOrBefore(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.sameOrBefore(ZonedDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> sameOrAfter(Instant date) {
        return new IsSameOrAfter<Instant, Instant>(TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    @Factory
    public static TemporalMatcher<Instant> sameOrAfter(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.sameOrAfter(ZonedDateTime.of(year, month.getValue(), day, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> sameMonthOfYear(Instant date) {
        return new IsMonth<Instant>(TemporalConverters.INSTANT_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<Instant> sameDayOfMonth(Instant date) {
        return new IsDayOfMonth<Instant>(TemporalConverters.INSTANT_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<Instant> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<Instant>(TemporalConverters.INSTANT_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<Instant> sameYear(Instant date) {
        return new IsYear<Instant>(TemporalConverters.INSTANT_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<Instant> isYear(int year) {
        return new IsYear<Instant>(TemporalConverters.INSTANT_AS_YEAR, TemporalProviders.year(year));
    }

    public static TemporalMatcher<Instant> within(long period, ChronoUnit unit, Instant date) {
        return new IsWithin<Instant, Instant>(Interval.of(period, unit), TemporalConverters.INSTANT_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    public static TemporalMatcher<Instant> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return InstantMatchers.within(period, unit, ZonedDateTime.of(year, month.getValue(), dayofMonth, hour, minute, second, nanos, tz).toInstant());
    }

    public static TemporalMatcher<Instant> isYesterday() {
        return InstantMatchers.sameDay(Instant.now().plus(-1L, ChronoUnit.DAYS));
    }

    public static TemporalMatcher<Instant> isToday() {
        return InstantMatchers.sameDay(Instant.now());
    }

    public static TemporalMatcher<Instant> isTomorrow() {
        return InstantMatchers.sameDay(Instant.now().plus(1L, ChronoUnit.DAYS));
    }

    public static TemporalMatcher<Instant> sameDayOfWeek(Instant date) {
        return InstantMatchers.isDayOfWeek(TemporalConverters.INSTANT_AS_DAYOFWEEK.apply(date, Optional.empty()));
    }

    public static TemporalMatcher<Instant> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<Instant>(TemporalConverters.INSTANT_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<Instant> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<Instant>(TemporalConverters.INSTANT_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<Instant> isMonday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<Instant> isTuesday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<Instant> isWednesday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<Instant> isThursday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<Instant> isFriday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<Instant> isSaturday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<Instant> isSunday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<Instant> isWeekday() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<Instant> isWeekend() {
        return InstantMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<Instant> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<Instant>(TemporalConverters.INSTANT_AS_ZONEDDATETIME);
    }

    public static TemporalMatcher<Instant> isMinimum(ChronoField field) {
        return new IsMinimum<Instant>(TemporalConverters.INSTANT_AS_ZONEDDATETIME, field);
    }

    public static TemporalMatcher<Instant> isLastDayOfMonth() {
        return new IsLastDayOfMonth<Instant>(TemporalConverters.INSTANT_AS_ZONEDDATETIME);
    }

    public static TemporalMatcher<Instant> isMaximum(ChronoField field) {
        return new IsMaximum<Instant>(TemporalConverters.INSTANT_AS_ZONEDDATETIME, field);
    }

    public static TemporalMatcher<Instant> isMonth(Month month) {
        return new IsMonth<Instant>(TemporalConverters.INSTANT_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<Instant> isJanuary() {
        return InstantMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<Instant> isFebruary() {
        return InstantMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<Instant> isMarch() {
        return InstantMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<Instant> isApril() {
        return InstantMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<Instant> isMay() {
        return InstantMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<Instant> isJune() {
        return InstantMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<Instant> isJuly() {
        return InstantMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<Instant> isAugust() {
        return InstantMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<Instant> isSeptember() {
        return InstantMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<Instant> isOctober() {
        return InstantMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<Instant> isNovember() {
        return InstantMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<Instant> isDecember() {
        return InstantMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<Instant> isLeapYear() {
        return new IsLeapYear<Instant>(TemporalConverters.INSTANT_AS_YEAR);
    }

    public static TemporalMatcher<Instant> isHour(int hour) {
        return new IsHour<Instant>(TemporalConverters.INSTANT_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static TemporalMatcher<Instant> sameHourOfDay(Instant date) {
        return new IsHour<Instant>(TemporalConverters.INSTANT_AS_HOUR, TemporalProviders.hour(date));
    }

    public static TemporalMatcher<Instant> isMinute(int minute) {
        return new IsMinute<Instant>(TemporalConverters.INSTANT_AS_MINUTE, TemporalProviders.minute(minute));
    }

    public static TemporalMatcher<Instant> sameMinuteOfHour(Instant date) {
        return new IsMinute<Instant>(TemporalConverters.INSTANT_AS_MINUTE, TemporalProviders.minute(date));
    }

    public static TemporalMatcher<Instant> isSecond(int second) {
        return new IsSecond<Instant>(TemporalConverters.INSTANT_AS_SECOND, TemporalProviders.second(second));
    }

    public static TemporalMatcher<Instant> sameSecondOfMinute(Instant date) {
        return new IsSecond<Instant>(TemporalConverters.INSTANT_AS_SECOND, TemporalProviders.second(date));
    }
}

