/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functor {
    private static final Logger log = LoggerFactory.getLogger(Functor.class);
    private final Object invokee;
    private final Class<?> clazz;
    private final String methodName;
    private Object[] args;
    private final Class<?>[] types;
    private Method methodToInvoke;

    Functor() {
        throw new IllegalArgumentException("Must provide at least one argument");
    }

    public Functor(Object _invokee, String _methodName) {
        this(null, _invokee, _methodName, null, null);
    }

    public Functor(Class<?> _clazz, String _methodName) {
        this(_clazz, null, _methodName, null, null);
    }

    public Functor(Object _invokee, String _methodName, Class<?>[] _types) {
        this(null, _invokee, _methodName, null, _types);
    }

    public Functor(Class<?> _clazz, String _methodName, Class<?>[] _types) {
        this(_clazz, null, _methodName, null, _types);
    }

    public Functor(String _methodName) {
        this(null, null, _methodName, null, null);
    }

    public Functor(String _methodName, Class<?>[] _types) {
        this(null, null, _methodName, null, _types);
    }

    public Functor(Object _invokee, String _methodName, Object[] _args) {
        this(null, _invokee, _methodName, _args, null);
    }

    public Functor(String _methodName, Object[] _args) {
        this(null, null, _methodName, _args, null);
    }

    private Functor(Class<?> _clazz, Object _invokee, String _methodName, Object[] _args, Class<?>[] _types) {
        if (_methodName == null) {
            throw new IllegalArgumentException("Methodname must not be null");
        }
        if (_clazz != null && _invokee != null) {
            throw new IllegalArgumentException("Cannot provide both Class and Object");
        }
        if (_args != null && _types != null) {
            throw new IllegalArgumentException("Cannot provide both arguments and argument types");
        }
        this.clazz = _clazz != null ? _clazz : (_invokee != null ? _invokee.getClass() : null);
        this.invokee = _invokee;
        this.methodName = _methodName;
        this.args = _args;
        this.types = _types != null ? _types : (_args != null ? Functor._getTypes(_args) : null);
    }

    private Object doInvoke(Class<?> _class, Object _invokee, Object[] _args) {
        Class<?>[] argTypes = this.getTypes(_args);
        try {
            Method method = this.doCreateMethod(_class, argTypes);
            if (method == null) {
                String message = "Can't find method " + _class.getName() + "#" + this.methodName + Functor.typesToString(argTypes);
                log.error(message, new Throwable());
                throw new JMeterError(message);
            }
            return method.invoke(_invokee, _args);
        }
        catch (Exception e) {
            String message = "Trouble functing: " + _class.getName() + "." + this.methodName + "(...) :  invokee: " + _invokee + " " + e.getMessage();
            log.warn(message, (Throwable)e);
            throw new JMeterError(message, e);
        }
    }

    public Object invoke() {
        if (this.invokee == null) {
            throw new IllegalStateException("Cannot call invoke() - invokee not known");
        }
        return this.doInvoke(this.clazz, this.invokee, this.getArgs());
    }

    public Object invoke(Object p_invokee) {
        return this.invoke(p_invokee, this.getArgs());
    }

    public Object invoke(Object[] p_args) {
        if (this.invokee == null) {
            throw new IllegalStateException("Invokee was not provided in constructor");
        }
        return this.doInvoke(this.clazz, this.invokee, this.args != null ? this.args : p_args);
    }

    public Object invoke(Object p_invokee, Object[] p_args) {
        return this.doInvoke(this.clazz != null ? this.clazz : p_invokee.getClass(), this.invokee != null ? this.invokee : p_invokee, this.args != null ? this.args : p_args);
    }

    private synchronized Method doCreateMethod(Class<?> p_class, Class<?>[] p_types) {
        if (log.isDebugEnabled()) {
            log.debug("doCreateMethod() using " + this.toString() + "class=" + p_class.getName() + " types: " + Arrays.asList(p_types));
        }
        if (this.methodToInvoke == null) {
            try {
                this.methodToInvoke = p_class.getMethod(this.methodName, p_types);
            }
            catch (Exception e) {
                for (int i = 0; i < p_types.length; ++i) {
                    Class<?>[] interfaces;
                    Class<?> primitive = Functor.getPrimitive(p_types[i]);
                    if (primitive != null) {
                        this.methodToInvoke = this.doCreateMethod(p_class, Functor.getNewArray(i, primitive, p_types));
                        if (this.methodToInvoke != null) {
                            return this.methodToInvoke;
                        }
                    }
                    for (Class<?> anInterface : interfaces = p_types[i].getInterfaces()) {
                        this.methodToInvoke = this.doCreateMethod(p_class, Functor.getNewArray(i, anInterface, p_types));
                        if (this.methodToInvoke == null) continue;
                        return this.methodToInvoke;
                    }
                    Class<?> parent = p_types[i].getSuperclass();
                    if (parent == null) continue;
                    this.methodToInvoke = this.doCreateMethod(p_class, Functor.getNewArray(i, parent, p_types));
                    if (this.methodToInvoke == null) continue;
                    return this.methodToInvoke;
                }
            }
        }
        return this.methodToInvoke;
    }

    @Deprecated
    public boolean checkMethod(Object _invokee) {
        Method m = null;
        try {
            m = this.doCreateMethod(_invokee.getClass(), this.getTypes(this.args));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null != m;
    }

    @Deprecated
    public boolean checkMethod(Object _invokee, Class<?> c) {
        Method m = null;
        try {
            m = this.doCreateMethod(_invokee.getClass(), new Class[]{c});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null != m;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        if (this.clazz != null) {
            sb.append(this.clazz.getName());
        }
        if (this.invokee != null) {
            sb.append("@");
            sb.append(System.identityHashCode(this.invokee));
        }
        sb.append(".");
        sb.append(this.methodName);
        Functor.typesToString(sb, this.types);
        return sb.toString();
    }

    private static void typesToString(StringBuilder sb, Class<?>[] _types) {
        sb.append("(");
        if (_types != null) {
            for (int i = 0; i < _types.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(_types[i].getName());
            }
        }
        sb.append(")");
    }

    private static String typesToString(Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder();
        Functor.typesToString(sb, argTypes);
        return sb.toString();
    }

    private static Class<?> getPrimitive(Class<?> t) {
        if (t == null) {
            return null;
        }
        Class<Constable> c = null;
        if (t.equals(Integer.class)) {
            c = Integer.TYPE;
        } else if (t.equals(Long.class)) {
            c = Long.TYPE;
        } else if (t.equals(Double.class)) {
            c = Double.TYPE;
        } else if (t.equals(Float.class)) {
            c = Float.TYPE;
        } else if (t.equals(Byte.class)) {
            c = Byte.TYPE;
        } else if (t.equals(Boolean.class)) {
            c = Boolean.TYPE;
        } else if (t.equals(Short.class)) {
            c = Short.TYPE;
        } else if (t.equals(Character.class)) {
            c = Character.TYPE;
        }
        return c;
    }

    private static Class<?>[] getNewArray(int i, Class<?> replacement, Class<?>[] orig) {
        Class[] newArray = new Class[orig.length];
        for (int j = 0; j < newArray.length; ++j) {
            newArray[j] = j == i ? replacement : orig[j];
        }
        return newArray;
    }

    private Class<?>[] getTypes(Object[] _args) {
        if (this.types == null) {
            return Functor._getTypes(_args);
        }
        return this.types;
    }

    private static Class<?>[] _getTypes(Object[] _args) {
        Class[] _types;
        if (_args != null) {
            _types = new Class[_args.length];
            for (int i = 0; i < _args.length; ++i) {
                _types[i] = _args[i].getClass();
            }
        } else {
            _types = new Class[]{};
        }
        return _types;
    }

    private Object[] getArgs() {
        if (this.args == null) {
            this.args = new Object[0];
        }
        return this.args;
    }
}

