/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandlerExKt;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.TooltipsTheme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTarget;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.CrosshairComponent;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.RetainableComponents;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.TooltipBox;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.LocatedTargetsPicker;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TransformedTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u0001GBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013JB\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0005022\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J,\u0010:\u001a\b\u0012\u0004\u0012\u00020*022\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\u0006\u00105\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u0010H\u0002J\b\u0010>\u001a\u00020.H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010@\u001a\u00020\u0007H\u0002J\b\u0010A\u001a\u00020.H\u0002J\u001e\u0010B\u001a\u00020.2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020%022\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020\u0007H\u0002J\f\u0010F\u001a\u00020\u0005*\u00020\u000eH\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\u00020$*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0018\u0010(\u001a\u00020)*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006H"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "decorationLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "flippedAxis", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "xAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "yAxisTheme", "tooltipsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/TooltipsTheme;", "plotBackground", "Lorg/jetbrains/letsPlot/commons/values/Color;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/TooltipsTheme;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;)V", "crosshairStorage", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/RetainableComponents;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/CrosshairComponent;", "myLayoutManager", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager;", "myTileInfos", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;", "Lkotlin/collections/ArrayList;", "myTooltipLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "regs", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "tooltipStorage", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "getOrientation", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;)Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "style", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "getStyle", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;)Ljava/lang/String;", "addTileInfo", "", "geomBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "axisOrigin", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "createTooltipSpecs", "lookupResults", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "ctx", "dispose", "findTileInfo", "plotCoord", "hideTooltips", "showCrosshair", "tooltips", "showTooltips", "cursor", "isDark", "TileInfo", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nTooltipRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1#2:328\n1#2:357\n766#3:329\n857#3,2:330\n1549#3:332\n1620#3,3:333\n1855#3,2:336\n1747#3,3:338\n1747#3,3:341\n766#3:344\n857#3,2:345\n1603#3,9:347\n1855#3:356\n1856#3:358\n1612#3:359\n1855#3,2:360\n1855#3:362\n1855#3,2:363\n1856#3:365\n*S KotlinDebug\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer\n*L\n193#1:357\n99#1:329\n99#1:330,2\n101#1:332\n101#1:333,3\n166#1:336,2\n185#1:338,3\n186#1:341,3\n192#1:344\n192#1:345,2\n193#1:347,9\n193#1:356\n193#1:358\n193#1:359\n199#1:360,2\n245#1:362\n247#1:363,2\n245#1:365\n*E\n"})
public final class TooltipRenderer
implements Disposable {
    private final boolean flippedAxis;
    @NotNull
    private final AxisTheme xAxisTheme;
    @NotNull
    private final AxisTheme yAxisTheme;
    @NotNull
    private final TooltipsTheme tooltipsTheme;
    @NotNull
    private final Color plotBackground;
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final CompositeRegistration regs;
    @NotNull
    private final LayoutManager myLayoutManager;
    @NotNull
    private final SvgGElement myTooltipLayer;
    @NotNull
    private final ArrayList<TileInfo> myTileInfos;
    @NotNull
    private final RetainableComponents<TooltipBox> tooltipStorage;
    @NotNull
    private final RetainableComponents<CrosshairComponent> crosshairStorage;

    public TooltipRenderer(@NotNull SvgNode decorationLayer, boolean flippedAxis, @NotNull DoubleVector plotSize, @NotNull AxisTheme xAxisTheme, @NotNull AxisTheme yAxisTheme, @NotNull TooltipsTheme tooltipsTheme, @NotNull Color plotBackground, @NotNull PlotContext plotContext, @NotNull MouseEventPeer mouseEventPeer) {
        SvgGElement it;
        SvgGElement svgGElement;
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)xAxisTheme, (String)"xAxisTheme");
        Intrinsics.checkNotNullParameter((Object)yAxisTheme, (String)"yAxisTheme");
        Intrinsics.checkNotNullParameter((Object)tooltipsTheme, (String)"tooltipsTheme");
        Intrinsics.checkNotNullParameter((Object)plotBackground, (String)"plotBackground");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        this.flippedAxis = flippedAxis;
        this.xAxisTheme = xAxisTheme;
        this.yAxisTheme = yAxisTheme;
        this.tooltipsTheme = tooltipsTheme;
        this.plotBackground = plotBackground;
        this.plotContext = plotContext;
        this.regs = new CompositeRegistration(new Registration[0]);
        this.myTileInfos = new ArrayList();
        DoubleRectangle viewport = new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize);
        this.myLayoutManager = new LayoutManager(viewport, LayoutManager.HorizontalAlignment.LEFT);
        SvgGElement svgGElement2 = svgGElement = new SvgGElement();
        TooltipRenderer tooltipRenderer = this;
        boolean bl = false;
        decorationLayer.children().add((Object)it);
        tooltipRenderer.myTooltipLayer = svgGElement;
        it = svgGElement = new SvgGElement();
        Function0 function0 = 2.INSTANCE;
        tooltipRenderer = this;
        boolean bl2 = false;
        this.myTooltipLayer.children().add((Object)it);
        Unit unit = Unit.INSTANCE;
        SvgNode svgNode = (SvgNode)svgGElement;
        Function0 function02 = function0;
        tooltipRenderer.crosshairStorage = new RetainableComponents(function02, svgNode);
        it = svgGElement = new SvgGElement();
        function0 = 4.INSTANCE;
        tooltipRenderer = this;
        boolean bl3 = false;
        this.myTooltipLayer.children().add((Object)it);
        unit = Unit.INSTANCE;
        SvgNode svgNode2 = (SvgNode)svgGElement;
        Function0 function03 = function0;
        tooltipRenderer.tooltipStorage = new RetainableComponents(function03, svgNode2);
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_MOVED, EventHandlerExKt.handler((Function1)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.showTooltips(it.getLocation().toDoubleVector());
            }
        }))));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_DRAGGED, EventHandlerExKt.handler((Function1)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hideTooltips();
            }
        }))));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_LEFT, EventHandlerExKt.handler((Function1)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hideTooltips();
            }
        }))));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_DOUBLE_CLICKED, EventHandlerExKt.handler((Function1)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hideTooltips();
            }
        }))));
    }

    public void dispose() {
        this.myTileInfos.clear();
        this.regs.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final void showTooltips(DoubleVector cursor) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable<LayoutManager.PositionedTooltip> $this$map$iv;
        TooltipSpec it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        TileInfo tileInfo = this.findTileInfo(cursor);
        if (tileInfo == null) {
            this.hideTooltips();
            return;
        }
        List<TooltipSpec> tooltipSpecs = this.createTooltipSpecs(tileInfo.findTargets(cursor), tileInfo.getAxisOrigin(), this.plotContext);
        DoubleRectangle geomBounds = tileInfo.getGeomBounds();
        List<TooltipBox> tooltipComponents = this.tooltipStorage.provide(tooltipSpecs.size());
        Iterable iterable = tooltipSpecs;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TooltipSpec)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getLines()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)tooltipComponents);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TooltipBox tooltipBox;
            double d;
            Color color;
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TooltipSpec spec = (TooltipSpec)it.component1();
            TooltipBox tooltipBox2 = (TooltipBox)((Object)it.component2());
            if (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP) {
                color = this.xAxisTheme.tooltipFill();
            } else if (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP) {
                color = this.yAxisTheme.tooltipFill();
            } else if (spec.isSide()) {
                Color color2 = spec.getFill();
                if (color2 == null) {
                    color2 = Color.Companion.getWHITE();
                }
                Color it2 = color2;
                boolean bl3 = false;
                color = Colors.INSTANCE.mimicTransparency(it2, (double)it2.getAlpha() / 255.0, Color.Companion.getWHITE());
            } else {
                color = this.tooltipsTheme.tooltipFill();
            }
            Color fillColor = color;
            Color borderColor = spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipColor() : (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipColor() : (spec.isSide() ? (this.isDark(fillColor) ? Defaults.Common.Tooltip.INSTANCE.getLIGHT_TEXT_COLOR() : Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR()) : this.tooltipsTheme.tooltipColor()));
            Object[] objectArray = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
            Color textColor = !CollectionsKt.listOf((Object[])objectArray).contains(spec.getLayoutHint().getKind()) && spec.isSide() ? borderColor : null;
            double strokeWidth = spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipStrokeWidth() : (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipStrokeWidth() : (spec.isSide() ? 1.0 : this.tooltipsTheme.tooltipStrokeWidth()));
            switch (WhenMappings.$EnumSwitchMapping$0[spec.getLayoutHint().getKind().ordinal()]) {
                case 1: 
                case 2: {
                    d = 0.0;
                    break;
                }
                default: {
                    d = 4.0;
                }
            }
            double borderRadius = d;
            TooltipBox $this$showTooltips_u24lambda_u246_u24lambda_u245 = tooltipBox = tooltipBox2;
            boolean bl4 = false;
            $this$showTooltips_u24lambda_u246_u24lambda_u245.getRootGroup().visibility().set((Object)SvgGraphicsElement.Visibility.HIDDEN);
            tooltipBox.update(fillColor, textColor, borderColor, strokeWidth, spec.getLines(), spec.getTitle(), this.getStyle(spec), spec.getLayoutHint().getKind() == TipLayoutHint.Kind.ROTATED_TOOLTIP, spec.getMinWidth(), borderRadius, CollectionsKt.distinct((Iterable)spec.getMarkerColors()), this.plotBackground);
            collection.add(new LayoutManager.MeasuredTooltip(spec, tooltipBox2, strokeWidth));
        }
        List $this$showTooltips_u24lambda_u247 = (List)destination$iv$iv;
        boolean bl = false;
        List<LayoutManager.PositionedTooltip> tooltips = $this$map$iv = this.myLayoutManager.arrange($this$showTooltips_u24lambda_u247, cursor, geomBounds, tileInfo.getHAxisTooltipPosition(), tileInfo.getVAxisTooltipPosition());
        boolean bl5 = false;
        this.showCrosshair(tooltips, geomBounds);
        $this$map$iv = $this$map$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TooltipBox tooltipBox;
            LayoutManager.PositionedTooltip arranged = (LayoutManager.PositionedTooltip)element$iv;
            boolean bl6 = false;
            TooltipBox $this$showTooltips_u24lambda_u2410_u24lambda_u249 = tooltipBox = arranged.getTooltipBox();
            boolean bl7 = false;
            $this$showTooltips_u24lambda_u2410_u24lambda_u249.getRootGroup().visibility().set((Object)SvgGraphicsElement.Visibility.VISIBLE);
            $this$showTooltips_u24lambda_u2410_u24lambda_u249.setPosition(arranged.getTooltipCoord(), arranged.getStemCoord(), this.getOrientation(arranged), arranged.getTooltipSpec().getLayoutHint().getKind() == TipLayoutHint.Kind.ROTATED_TOOLTIP);
        }
    }

    private final void hideTooltips() {
        this.tooltipStorage.provide(0);
        this.crosshairStorage.provide(0);
    }

    /*
     * WARNING - void declaration
     */
    private final void showCrosshair(List<LayoutManager.PositionedTooltip> tooltips, DoubleRectangle geomBounds) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object tooltip;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean showHorizontal;
        Object element$iv3;
        boolean showVertical;
        block11: {
            boolean bl;
            boolean bl2;
            block10: {
                Iterable $this$any$iv = tooltips;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv2;
                        boolean bl3 = false;
                        if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            showVertical = bl2;
            Iterable $this$any$iv = tooltips;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv3;
                    boolean bl4 = false;
                    if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP)) continue;
                    bl = true;
                    break block11;
                }
                bl = showHorizontal = false;
            }
        }
        if (!showVertical && !showHorizontal) {
            this.crosshairStorage.provide(0);
            return;
        }
        Iterable $i$f$any = tooltips;
        boolean $i$f$filter = false;
        element$iv3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            tooltip = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl = false;
            if (!((LayoutManager.PositionedTooltip)tooltip).getTooltipSpec().isCrosshairEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        tooltip = $this$forEach$iv$iv$iv.iterator();
        while (tooltip.hasNext()) {
            DoubleVector it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = tooltip.next();
            boolean bl = false;
            LayoutManager.PositionedTooltip tooltip2 = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl5 = false;
            if (tooltip2.getTooltipSpec().getLayoutHint().getCoord() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List coords = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        List<CrosshairComponent> crosshariComponents = this.crosshairStorage.provide(coords.size());
        Iterable $i$f$mapNotNull22 = CollectionsKt.zip((Iterable)coords, (Iterable)crosshariComponents);
        boolean $i$f$forEach2 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            Pair pair = (Pair)element$iv4;
            boolean bl = false;
            DoubleVector coord = (DoubleVector)pair.component1();
            CrosshairComponent crosshairComponent = (CrosshairComponent)((Object)pair.component2());
            crosshairComponent.update(coord, geomBounds, showHorizontal, showVertical);
        }
    }

    public final void addTileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
        TileInfo tileInfo = new TileInfo(geomBounds, targetLocators, layerYOrientations, this.flippedAxis, axisOrigin, hAxisTooltipPosition, vAxisTooltipPosition);
        this.myTileInfos.add(tileInfo);
    }

    private final TileInfo findTileInfo(DoubleVector plotCoord) {
        for (TileInfo tileInfo : this.myTileInfos) {
            if (!tileInfo.contains(plotCoord)) continue;
            return tileInfo;
        }
        return null;
    }

    private final List<TooltipSpec> createTooltipSpecs(List<? extends GeomTargetLocator.LookupResult> lookupResults, DoubleVector axisOrigin, PlotContext ctx) {
        ArrayList tooltipSpecs = new ArrayList();
        Iterable $this$forEach$iv = lookupResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeomTargetLocator.LookupResult result = (GeomTargetLocator.LookupResult)element$iv;
            boolean bl = false;
            TooltipSpecFactory factory = new TooltipSpecFactory(result.getContextualMapping(), axisOrigin, this.flippedAxis, this.xAxisTheme, this.yAxisTheme);
            Iterable $this$forEach$iv2 = result.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GeomTarget geomTarget = (GeomTarget)element$iv2;
                boolean bl2 = false;
                tooltipSpecs.addAll(factory.create(geomTarget, ctx));
            }
        }
        return tooltipSpecs;
    }

    private final boolean isDark(Color $this$isDark) {
        return Colors.INSTANCE.luminance($this$isDark) < 0.5;
    }

    private final String getStyle(TooltipSpec $this$style) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$style.getLayoutHint().getKind().ordinal()]) {
            case 1: {
                string = "axis-tooltip-text-" + this.xAxisTheme.getAxis();
                break;
            }
            case 2: {
                string = "axis-tooltip-text-" + this.yAxisTheme.getAxis();
                break;
            }
            case 3: {
                string = "tooltip-text";
                break;
            }
            case 4: {
                string = "tooltip-text";
                break;
            }
            case 5: {
                string = "tooltip-text";
                break;
            }
            case 6: {
                string = "tooltip-text";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final TooltipBox.Orientation getOrientation(LayoutManager.PositionedTooltip $this$orientation) {
        TooltipBox.Orientation orientation;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$orientation.getHintKind$plot_builder().ordinal()]) {
            case 4: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 2: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 3: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 5: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 1: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 6: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return orientation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001f BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001c\u001a\u00020\u000bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;", "", "geomBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "", "flippedAxis", "axisOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;)V", "getAxisOrigin", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getGeomBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getHAxisTooltipPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "transformedLocators", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "getVAxisTooltipPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "contains", "plotCoord", "findTargets", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "FlippedTileTargetLocator", "TileTargetLocator", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1549#2:328\n1620#2,3:329\n*S KotlinDebug\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo\n*L\n264#1:328\n264#1:329,3\n*E\n"})
    private static final class TileInfo {
        @NotNull
        private final DoubleRectangle geomBounds;
        private final boolean flippedAxis;
        @NotNull
        private final DoubleVector axisOrigin;
        @NotNull
        private final HorizontalAxisTooltipPosition hAxisTooltipPosition;
        @NotNull
        private final VerticalAxisTooltipPosition vAxisTooltipPosition;
        @NotNull
        private final List<TransformedTargetLocator> transformedLocators;

        /*
         * WARNING - void declaration
         */
        public TileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, boolean flippedAxis, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
            Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
            Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
            Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
            Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
            Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
            this.geomBounds = geomBounds;
            this.flippedAxis = flippedAxis;
            this.axisOrigin = axisOrigin;
            this.hAxisTooltipPosition = hAxisTooltipPosition;
            this.vAxisTooltipPosition = vAxisTooltipPosition;
            Iterable iterable = CollectionsKt.zip((Iterable)targetLocators, (Iterable)layerYOrientations);
            TileInfo tileInfo = this;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TransformedTargetLocator transformedTargetLocator;
                boolean flip;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GeomTargetLocator targetLocator = (GeomTargetLocator)pair.component1();
                boolean isYOrientation = (Boolean)pair.component2();
                boolean bl2 = flip = isYOrientation ? !this.flippedAxis : this.flippedAxis;
                if (bl2) {
                    transformedTargetLocator = new FlippedTileTargetLocator(targetLocator);
                } else if (!bl2) {
                    transformedTargetLocator = new TileTargetLocator(targetLocator);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(transformedTargetLocator);
            }
            tileInfo.transformedLocators = (List)destination$iv$iv;
        }

        @NotNull
        public final DoubleRectangle getGeomBounds() {
            return this.geomBounds;
        }

        @NotNull
        public final DoubleVector getAxisOrigin() {
            return this.axisOrigin;
        }

        @NotNull
        public final HorizontalAxisTooltipPosition getHAxisTooltipPosition() {
            return this.hAxisTooltipPosition;
        }

        @NotNull
        public final VerticalAxisTooltipPosition getVAxisTooltipPosition() {
            return this.vAxisTooltipPosition;
        }

        @NotNull
        public final List<GeomTargetLocator.LookupResult> findTargets(@NotNull DoubleVector plotCoord) {
            LocatedTargetsPicker locatedTargetsPicker;
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            LocatedTargetsPicker $this$findTargets_u24lambda_u241 = locatedTargetsPicker = new LocatedTargetsPicker(this.flippedAxis, plotCoord);
            boolean bl = false;
            for (TransformedTargetLocator locator : this.transformedLocators) {
                GeomTargetLocator.LookupResult result = locator.search(plotCoord);
                if (result == null) continue;
                $this$findTargets_u24lambda_u241.addLookupResult(result);
            }
            LocatedTargetsPicker targetsPicker = locatedTargetsPicker;
            return targetsPicker.getPicked();
        }

        public final boolean contains(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            return this.geomBounds.contains(plotCoord);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo$FlippedTileTargetLocator;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "locator", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;)V", "convertToPlotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class FlippedTileTargetLocator
        extends TransformedTargetLocator {
            public FlippedTileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin()).flip();
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.flip().add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo$TileTargetLocator;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "locator", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;)V", "convertToPlotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class TileTargetLocator
        extends TransformedTargetLocator {
            public TileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TipLayoutHint.Kind.values().length];
            try {
                nArray[TipLayoutHint.Kind.X_AXIS_TOOLTIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.Y_AXIS_TOOLTIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.VERTICAL_TOOLTIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.HORIZONTAL_TOOLTIP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.CURSOR_TOOLTIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.ROTATED_TOOLTIP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

