/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.postgres;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.JsonEventSerializer;
import org.apache.james.eventsourcing.eventstore.postgres.PostgresEventStoreDataDefinition;
import org.apache.james.util.ReactorUtils;
import org.jooq.JSON;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class PostgresEventStoreDAO {
    private PostgresExecutor postgresExecutor;
    private JsonEventSerializer jsonEventSerializer;

    @Inject
    public PostgresEventStoreDAO(PostgresExecutor postgresExecutor, JsonEventSerializer jsonEventSerializer) {
        this.postgresExecutor = postgresExecutor;
        this.jsonEventSerializer = jsonEventSerializer;
    }

    public Mono<Void> appendAll(java.util.List<Event> events, Optional<EventId> lastSnapshot) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME, PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID, PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT_ID, PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT).valuesOfRecords((Collection)events.stream().map(event -> dslContext.newRecord(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID, PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT_ID, PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT).value1((Object)event.getAggregateId().asAggregateKey()).value2((Object)event.eventId().serialize()).value3((Object)this.convertToJooqJson((Event)event))).collect(ImmutableList.toImmutableList())))).then(lastSnapshot.map(eventId -> this.insertSnapshot(((Event)events.iterator().next()).getAggregateId(), (EventId)eventId)).orElse(Mono.empty()));
    }

    private Mono<Void> insertSnapshot(AggregateId aggregateId, EventId snapshotId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.update(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME).set(PostgresEventStoreDataDefinition.PostgresEventStoreTable.SNAPSHOT, (Object)snapshotId.serialize()).where(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID.eq((Object)aggregateId.asAggregateKey()))));
    }

    private JSON convertToJooqJson(Event event) {
        try {
            return JSON.json((String)this.jsonEventSerializer.serialize(event));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Mono<EventId> getSnapshot(AggregateId aggregateId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresEventStoreDataDefinition.PostgresEventStoreTable.SNAPSHOT).from(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME).where(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID.eq((Object)aggregateId.asAggregateKey())).limit((Number)1))).map(record -> EventId.fromSerialized((int)Optional.ofNullable((Integer)record.get(PostgresEventStoreDataDefinition.PostgresEventStoreTable.SNAPSHOT)).orElse(0)));
    }

    public Mono<History> getEventsOfAggregate(AggregateId aggregateId, EventId snapshotId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME).where(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID.eq((Object)aggregateId.asAggregateKey())).and(PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT_ID.greaterOrEqual((Object)snapshotId.value())).orderBy(PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT_ID))).concatMap(this::toEvent).collect(ImmutableList.toImmutableList()).map(this::asHistory);
    }

    public Mono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME).where(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID.eq((Object)aggregateId.asAggregateKey())).orderBy(PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT_ID))).concatMap(this::toEvent).collect(ImmutableList.toImmutableList()).map(this::asHistory);
    }

    public Mono<Void> delete(AggregateId aggregateId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresEventStoreDataDefinition.PostgresEventStoreTable.TABLE_NAME).where(PostgresEventStoreDataDefinition.PostgresEventStoreTable.AGGREGATE_ID.eq((Object)aggregateId.asAggregateKey()))));
    }

    private History asHistory(java.util.List<Event> events) {
        return History.of((List)CollectionConverters.asScala(events).toList());
    }

    private Mono<Event> toEvent(Record record) {
        return Mono.fromCallable(() -> this.jsonEventSerializer.deserialize(((JSON)record.get(PostgresEventStoreDataDefinition.PostgresEventStoreTable.EVENT)).data())).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }
}

