/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.api;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.export.api.FileExtension;

public interface ExportedFileNamesGenerator {
    public static String generateFileName(Optional<String> fileCustomPrefix, BlobId blobId, Optional<FileExtension> fileExtension) {
        Preconditions.checkNotNull((Object)blobId);
        String fileNameWithPrefix = fileCustomPrefix.map(prefix -> prefix + blobId.asString()).orElse(blobId.asString());
        return fileExtension.map(extension -> extension.appendExtension(fileNameWithPrefix)).orElse(fileNameWithPrefix);
    }
}

