/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.VacationResponse;

@JsonDeserialize(builder=Builder.class)
public class SetVacationRequest
implements JmapRequest {
    private static final String ISSUER = "SetVacationRequest";
    private final Map<String, VacationResponse> update;

    public static Builder builder() {
        return new Builder();
    }

    private SetVacationRequest(Map<String, VacationResponse> update) {
        this.update = update;
    }

    public Map<String, VacationResponse> getUpdate() {
        return this.update;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.update.entrySet().size() == 1 && this.update.containsKey("singleton");
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Map<String, VacationResponse> update = Maps.newHashMap();

        public Builder accountId(String accountId) {
            if (accountId != null) {
                throw new JmapFieldNotSupportedException(SetVacationRequest.ISSUER, "accountId");
            }
            return this;
        }

        public Builder update(Map<String, VacationResponse> update) {
            this.update.putAll(update);
            return this;
        }

        @JsonIgnore
        public Builder update(String id, VacationResponse vacationResponse) {
            this.update.put(id, vacationResponse);
            return this;
        }

        public SetVacationRequest build() {
            return new SetVacationRequest((Map<String, VacationResponse>)ImmutableMap.copyOf(this.update));
        }
    }
}

