/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractLinearFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

public class TableLinearFillOperator
extends AbstractLinearFillOperator {
    private final int helperColumnIndex;

    public TableLinearFillOperator(OperatorContext operatorContext, ILinearFill[] fillArray, Operator child, int helperColumnIndex) {
        super(operatorContext, fillArray, child);
        this.helperColumnIndex = helperColumnIndex;
    }

    @Override
    Column getHelperColumn(TsBlock tsBlock) {
        return tsBlock.getColumn(this.helperColumnIndex);
    }

    @Override
    Integer getLastRowIndexForNonNullHelperColumn(TsBlock tsBlock) {
        int i;
        Column helperColumn = this.getHelperColumn(tsBlock);
        int size = tsBlock.getPositionCount();
        if (!helperColumn.mayHaveNull()) {
            return size - 1;
        }
        for (i = size - 1; i >= 0 && helperColumn.isNull(i); --i) {
        }
        return i;
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + 4L;
    }
}

