/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDHT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private DoubleDHT_1D dhtColumns;
    private DoubleDHT_1D dhtRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_2D(long rows, long columns) {
        if (rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowsl = rows;
        this.columnsl = columns;
        if (rows * columns >= CommonUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtRows = new DoubleDHT_1D(rows);
        this.dhtColumns = rows == columns ? this.dhtRows : new DoubleDHT_1D(columns);
    }

    public void forward(final double[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(a, i * DoubleDHT_2D.this.columns);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r * DoubleDHT_2D.this.columns + c];
                                }
                                DoubleDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    a[r * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
                double[] temp = new double[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final DoubleLargeArray a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(a, i * this.columnsl);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(a, i * DoubleDHT_2D.this.columnsl);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstColumn = (long)l * p;
                    final long lastColumn = l == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_2D.this.rowsl, false);
                            for (long c = firstColumn; c < lastColumn; ++c) {
                                long r;
                                for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                    temp.setDouble(r, a.getDouble(r * DoubleDHT_2D.this.columnsl + c));
                                }
                                DoubleDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                    a.setDouble(r * DoubleDHT_2D.this.columnsl + c, temp.getDouble(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(a, i * this.columnsl);
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setDouble(r, a.getDouble(r * this.columnsl + c));
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a.setDouble(r * this.columnsl + c, temp.getDouble(r));
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final double[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(a[i]);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                DoubleDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
                double[] temp = new double[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(a, i * DoubleDHT_2D.this.columns, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r * DoubleDHT_2D.this.columns + c];
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    a[r * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
                double[] temp = new double[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(a, i * this.columnsl, scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(a, i * DoubleDHT_2D.this.columnsl, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstColumn = (long)l * p;
                    final long lastColumn = l == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_2D.this.rowsl, false);
                            for (long c = firstColumn; c < lastColumn; ++c) {
                                long r;
                                for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                    temp.setDouble(r, a.getDouble(r * DoubleDHT_2D.this.columnsl + c));
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                    a.setDouble(r * DoubleDHT_2D.this.columnsl + c, temp.getDouble(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(a, i * this.columnsl, scale);
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setDouble(r, a.getDouble(r * this.columnsl + c));
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a.setDouble(r * this.columnsl + c, temp.getDouble(r));
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(a[i], scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
                double[] temp = new double[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    private void ddxt2d_subth(final int isgn, final double[] a, final boolean scale) {
        int nthread = FastMath.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int idx1;
                        double[] t2;
                        block12: {
                            t2 = new double[ntf];
                            if (DoubleDHT_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c = 4 * n0; c < DoubleDHT_2D.this.columns; c += 4 * nthreads) {
                                    int idx22;
                                    int idx12;
                                    int r;
                                    for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                        idx12 = r * DoubleDHT_2D.this.columns + c;
                                        idx22 = DoubleDHT_2D.this.rows + r;
                                        t2[r] = a[idx12];
                                        t2[idx22] = a[idx12 + 1];
                                        t2[idx22 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx12 + 2];
                                        t2[idx22 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx12 + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 0);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 2 * DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 3 * DoubleDHT_2D.this.rows);
                                    for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                        idx12 = r * DoubleDHT_2D.this.columns + c;
                                        idx22 = DoubleDHT_2D.this.rows + r;
                                        a[idx12] = t2[r];
                                        a[idx12 + 1] = t2[idx22];
                                        a[idx12 + 2] = t2[idx22 + DoubleDHT_2D.this.rows];
                                        a[idx12 + 3] = t2[idx22 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c = 4 * n0; c < DoubleDHT_2D.this.columns; c += 4 * nthreads) {
                                    int idx23;
                                    int idx13;
                                    int r;
                                    for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                        idx13 = r * DoubleDHT_2D.this.columns + c;
                                        idx23 = DoubleDHT_2D.this.rows + r;
                                        t2[r] = a[idx13];
                                        t2[idx23] = a[idx13 + 1];
                                        t2[idx23 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx13 + 2];
                                        t2[idx23 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx13 + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 0, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rows, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 2 * DoubleDHT_2D.this.rows, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 3 * DoubleDHT_2D.this.rows, scale);
                                    for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                                        idx13 = r * DoubleDHT_2D.this.columns + c;
                                        idx23 = DoubleDHT_2D.this.rows + r;
                                        a[idx13] = t2[r];
                                        a[idx13 + 1] = t2[idx23];
                                        a[idx13 + 2] = t2[idx23 + DoubleDHT_2D.this.rows];
                                        a[idx13 + 3] = t2[idx23 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columns != 2) break block13;
                        int r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            idx1 = r * DoubleDHT_2D.this.columns + 2 * n0;
                            idx2 = r++;
                            t2[idx2] = a[idx1];
                            t2[idx2 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx1 + 1];
                        }
                        if (isgn == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(t2, 0);
                            DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rows);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(t2, 0, scale);
                            DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rows, scale);
                        }
                        r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            idx1 = r * DoubleDHT_2D.this.columns + 2 * n0;
                            idx2 = r++;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + DoubleDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        int nthread = (int)FastMath.min(this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        } else if (this.columnsl < 2L) {
            nt >>= 2;
        }
        final long ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        long idx2;
                        long idx1;
                        DoubleLargeArray t2;
                        block12: {
                            t2 = new DoubleLargeArray(ntf);
                            if (DoubleDHT_2D.this.columnsl <= 2L) break block12;
                            if (isgn == -1) {
                                for (long c = 4L * n0; c < DoubleDHT_2D.this.columnsl; c += (long)(4 * nthreads)) {
                                    long idx22;
                                    long idx12;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                        idx12 = r * DoubleDHT_2D.this.columnsl + c;
                                        idx22 = DoubleDHT_2D.this.rowsl + r;
                                        t2.setDouble(r, a.getDouble(idx12));
                                        t2.setDouble(idx22, a.getDouble(idx12 + 1L));
                                        t2.setDouble(idx22 + DoubleDHT_2D.this.rowsl, a.getDouble(idx12 + 2L));
                                        t2.setDouble(idx22 + 2L * DoubleDHT_2D.this.rowsl, a.getDouble(idx12 + 3L));
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 0L);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rowsl);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 2L * DoubleDHT_2D.this.rowsl);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 3L * DoubleDHT_2D.this.rowsl);
                                    for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                        idx12 = r * DoubleDHT_2D.this.columnsl + c;
                                        idx22 = DoubleDHT_2D.this.rowsl + r;
                                        a.setDouble(idx12, t2.getDouble(r));
                                        a.setDouble(idx12 + 1L, t2.getDouble(idx22));
                                        a.setDouble(idx12 + 2L, t2.getDouble(idx22 + DoubleDHT_2D.this.rowsl));
                                        a.setDouble(idx12 + 3L, t2.getDouble(idx22 + 2L * DoubleDHT_2D.this.rowsl));
                                    }
                                }
                            } else {
                                for (long c = 4L * n0; c < DoubleDHT_2D.this.columnsl; c += (long)(4 * nthreads)) {
                                    long idx23;
                                    long idx13;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                        idx13 = r * DoubleDHT_2D.this.columnsl + c;
                                        idx23 = DoubleDHT_2D.this.rowsl + r;
                                        t2.setDouble(r, a.getDouble(idx13));
                                        t2.setDouble(idx23, a.getDouble(idx13 + 1L));
                                        t2.setDouble(idx23 + DoubleDHT_2D.this.rowsl, a.getDouble(idx13 + 2L));
                                        t2.setDouble(idx23 + 2L * DoubleDHT_2D.this.rowsl, a.getDouble(idx13 + 3L));
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 0L, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rowsl, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 2L * DoubleDHT_2D.this.rowsl, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 3L * DoubleDHT_2D.this.rowsl, scale);
                                    for (r = 0L; r < DoubleDHT_2D.this.rowsl; ++r) {
                                        idx13 = r * DoubleDHT_2D.this.columnsl + c;
                                        idx23 = DoubleDHT_2D.this.rowsl + r;
                                        a.setDouble(idx13, t2.getDouble(r));
                                        a.setDouble(idx13 + 1L, t2.getDouble(idx23));
                                        a.setDouble(idx13 + 2L, t2.getDouble(idx23 + DoubleDHT_2D.this.rowsl));
                                        a.setDouble(idx13 + 3L, t2.getDouble(idx23 + 2L * DoubleDHT_2D.this.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columnsl != 2L) break block13;
                        long r = 0L;
                        while (r < DoubleDHT_2D.this.rowsl) {
                            idx1 = r * DoubleDHT_2D.this.columnsl + 2L * n0;
                            idx2 = r++;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + DoubleDHT_2D.this.rowsl, a.getDouble(idx1 + 1L));
                        }
                        if (isgn == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(t2, 0L);
                            DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rowsl);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(t2, 0L, scale);
                            DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rowsl, scale);
                        }
                        r = 0L;
                        while (r < DoubleDHT_2D.this.rowsl) {
                            idx1 = r * DoubleDHT_2D.this.columnsl + 2L * n0;
                            idx2 = r++;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + DoubleDHT_2D.this.rowsl));
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final double[][] a, final boolean scale) {
        int nthread = FastMath.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int r;
                        double[] t2;
                        block12: {
                            t2 = new double[ntf];
                            if (DoubleDHT_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c = 4 * n0; c < DoubleDHT_2D.this.columns; c += 4 * nthreads) {
                                    int idx22;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDHT_2D.this.rows; ++r2) {
                                        idx22 = DoubleDHT_2D.this.rows + r2;
                                        t2[r2] = a[r2][c];
                                        t2[idx22] = a[r2][c + 1];
                                        t2[idx22 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r2][c + 2];
                                        t2[idx22 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r2][c + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 0);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 2 * DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(t2, 3 * DoubleDHT_2D.this.rows);
                                    for (r2 = 0; r2 < DoubleDHT_2D.this.rows; ++r2) {
                                        idx22 = DoubleDHT_2D.this.rows + r2;
                                        a[r2][c] = t2[r2];
                                        a[r2][c + 1] = t2[idx22];
                                        a[r2][c + 2] = t2[idx22 + DoubleDHT_2D.this.rows];
                                        a[r2][c + 3] = t2[idx22 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c = 4 * n0; c < DoubleDHT_2D.this.columns; c += 4 * nthreads) {
                                    int idx23;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDHT_2D.this.rows; ++r3) {
                                        idx23 = DoubleDHT_2D.this.rows + r3;
                                        t2[r3] = a[r3][c];
                                        t2[idx23] = a[r3][c + 1];
                                        t2[idx23 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r3][c + 2];
                                        t2[idx23 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r3][c + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 0, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rows, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 2 * DoubleDHT_2D.this.rows, scale);
                                    DoubleDHT_2D.this.dhtRows.inverse(t2, 3 * DoubleDHT_2D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDHT_2D.this.rows; ++r3) {
                                        idx23 = DoubleDHT_2D.this.rows + r3;
                                        a[r3][c] = t2[r3];
                                        a[r3][c + 1] = t2[idx23];
                                        a[r3][c + 2] = t2[idx23 + DoubleDHT_2D.this.rows];
                                        a[r3][c + 3] = t2[idx23 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columns != 2) break block13;
                        for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                            idx2 = r;
                            t2[idx2] = a[r][2 * n0];
                            t2[idx2 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][2 * n0 + 1];
                        }
                        if (isgn == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(t2, 0);
                            DoubleDHT_2D.this.dhtRows.forward(t2, DoubleDHT_2D.this.rows);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(t2, 0, scale);
                            DoubleDHT_2D.this.dhtRows.inverse(t2, DoubleDHT_2D.this.rows, scale);
                        }
                        for (r = 0; r < DoubleDHT_2D.this.rows; ++r) {
                            idx2 = r;
                            a[r][2 * n0] = t2[idx2];
                            a[r][2 * n0 + 1] = t2[idx2 + DoubleDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < DoubleDHT_2D.this.rows; r += nthreads) {
                            DoubleDHT_2D.this.dhtColumns.forward(a, r * DoubleDHT_2D.this.columns);
                        }
                    } else {
                        for (int r = n0; r < DoubleDHT_2D.this.rows; r += nthreads) {
                            DoubleDHT_2D.this.dhtColumns.inverse(a, r * DoubleDHT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (long r = n0; r < DoubleDHT_2D.this.rowsl; r += (long)nthreads) {
                            DoubleDHT_2D.this.dhtColumns.forward(a, r * DoubleDHT_2D.this.columnsl);
                        }
                    } else {
                        for (long r = n0; r < DoubleDHT_2D.this.rowsl; r += (long)nthreads) {
                            DoubleDHT_2D.this.dhtColumns.inverse(a, r * DoubleDHT_2D.this.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final double[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < DoubleDHT_2D.this.rows; r += nthreads) {
                            DoubleDHT_2D.this.dhtColumns.forward(a[r]);
                        }
                    } else {
                        for (int r = n0; r < DoubleDHT_2D.this.rows; r += nthreads) {
                            DoubleDHT_2D.this.dhtColumns.inverse(a[r], scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_sub(int isgn, double[] a, boolean scale) {
        block16: {
            int idx1;
            int r;
            double[] t2;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t2 = new double[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx12;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            t2[r2] = a[idx12];
                            t2[idx2] = a[idx12 + 1];
                            t2[idx2 + this.rows] = a[idx12 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx12 + 3];
                        }
                        this.dhtRows.forward(t2, 0);
                        this.dhtRows.forward(t2, this.rows);
                        this.dhtRows.forward(t2, 2 * this.rows);
                        this.dhtRows.forward(t2, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            a[idx12] = t2[r2];
                            a[idx12 + 1] = t2[idx2];
                            a[idx12 + 2] = t2[idx2 + this.rows];
                            a[idx12 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx13;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            t2[r3] = a[idx13];
                            t2[idx2] = a[idx13 + 1];
                            t2[idx2 + this.rows] = a[idx13 + 2];
                            t2[idx2 + 2 * this.rows] = a[idx13 + 3];
                        }
                        this.dhtRows.inverse(t2, 0, scale);
                        this.dhtRows.inverse(t2, this.rows, scale);
                        this.dhtRows.inverse(t2, 2 * this.rows, scale);
                        this.dhtRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            a[idx13] = t2[r3];
                            a[idx13 + 1] = t2[idx2];
                            a[idx13 + 2] = t2[idx2 + this.rows];
                            a[idx13 + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                t2[r] = a[idx1];
                t2[this.rows + r] = a[idx1 + 1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t2, 0);
                this.dhtRows.forward(t2, this.rows);
            } else {
                this.dhtRows.inverse(t2, 0, scale);
                this.dhtRows.inverse(t2, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                a[idx1] = t2[r];
                a[idx1 + 1] = t2[this.rows + r];
            }
        }
    }

    private void ddxt2d_sub(int isgn, DoubleLargeArray a, boolean scale) {
        block16: {
            long idx1;
            long r;
            DoubleLargeArray t2;
            block15: {
                long nt = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    nt >>= 1;
                } else if (this.columnsl < 2L) {
                    nt >>= 2;
                }
                t2 = new DoubleLargeArray(nt);
                if (this.columnsl <= 2L) break block15;
                if (isgn == -1) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx12;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c;
                            idx2 = this.rowsl + r2;
                            t2.setDouble(r2, a.getDouble(idx12));
                            t2.setDouble(idx2, a.getDouble(idx12 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx12 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx12 + 3L));
                        }
                        this.dhtRows.forward(t2, 0L);
                        this.dhtRows.forward(t2, this.rowsl);
                        this.dhtRows.forward(t2, 2L * this.rowsl);
                        this.dhtRows.forward(t2, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c;
                            idx2 = this.rowsl + r2;
                            a.setDouble(idx12, t2.getDouble(r2));
                            a.setDouble(idx12 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx12 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx12 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx13;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c;
                            idx2 = this.rowsl + r3;
                            t2.setDouble(r3, a.getDouble(idx13));
                            t2.setDouble(idx2, a.getDouble(idx13 + 1L));
                            t2.setDouble(idx2 + this.rowsl, a.getDouble(idx13 + 2L));
                            t2.setDouble(idx2 + 2L * this.rowsl, a.getDouble(idx13 + 3L));
                        }
                        this.dhtRows.inverse(t2, 0L, scale);
                        this.dhtRows.inverse(t2, this.rowsl, scale);
                        this.dhtRows.inverse(t2, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t2, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c;
                            idx2 = this.rowsl + r3;
                            a.setDouble(idx13, t2.getDouble(r3));
                            a.setDouble(idx13 + 1L, t2.getDouble(idx2));
                            a.setDouble(idx13 + 2L, t2.getDouble(idx2 + this.rowsl));
                            a.setDouble(idx13 + 3L, t2.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                t2.setDouble(r, a.getDouble(idx1));
                t2.setDouble(this.rowsl + r, a.getDouble(idx1 + 1L));
            }
            if (isgn == -1) {
                this.dhtRows.forward(t2, 0L);
                this.dhtRows.forward(t2, this.rowsl);
            } else {
                this.dhtRows.inverse(t2, 0L, scale);
                this.dhtRows.inverse(t2, this.rowsl, scale);
            }
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                a.setDouble(idx1, t2.getDouble(r));
                a.setDouble(idx1 + 1L, t2.getDouble(this.rowsl + r));
            }
        }
    }

    private void ddxt2d_sub(int isgn, double[][] a, boolean scale) {
        block16: {
            int r;
            double[] t2;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t2 = new double[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t2[r2] = a[r2][c];
                            t2[idx2] = a[r2][c + 1];
                            t2[idx2 + this.rows] = a[r2][c + 2];
                            t2[idx2 + 2 * this.rows] = a[r2][c + 3];
                        }
                        this.dhtRows.forward(t2, 0);
                        this.dhtRows.forward(t2, this.rows);
                        this.dhtRows.forward(t2, 2 * this.rows);
                        this.dhtRows.forward(t2, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[r2][c] = t2[r2];
                            a[r2][c + 1] = t2[idx2];
                            a[r2][c + 2] = t2[idx2 + this.rows];
                            a[r2][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t2[r3] = a[r3][c];
                            t2[idx2] = a[r3][c + 1];
                            t2[idx2 + this.rows] = a[r3][c + 2];
                            t2[idx2 + 2 * this.rows] = a[r3][c + 3];
                        }
                        this.dhtRows.inverse(t2, 0, scale);
                        this.dhtRows.inverse(t2, this.rows, scale);
                        this.dhtRows.inverse(t2, 2 * this.rows, scale);
                        this.dhtRows.inverse(t2, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[r3][c] = t2[r3];
                            a[r3][c + 1] = t2[idx2];
                            a[r3][c + 2] = t2[idx2 + this.rows];
                            a[r3][c + 3] = t2[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                t2[r] = a[r][0];
                t2[this.rows + r] = a[r][1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t2, 0);
                this.dhtRows.forward(t2, this.rows);
            } else {
                this.dhtRows.inverse(t2, 0, scale);
                this.dhtRows.inverse(t2, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                a[r][0] = t2[r];
                a[r][1] = t2[this.rows + r];
            }
        }
    }

    private void yTransform(double[] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            int idx1 = r * this.columns;
            int idx2 = mRow * this.columns;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                double A2 = a[idx1 + c];
                double B = a[idx2 + c];
                double C2 = a[idx1 + mCol];
                double D = a[idx2 + mCol];
                double E = (A2 + D - (B + C2)) / 2.0;
                a[idx1 + c] = A2 - E;
                a[idx2 + c] = B + E;
                a[idx1 + mCol] = C2 + E;
                a[idx2 + mCol] = D - E;
            }
        }
    }

    private void yTransform(DoubleLargeArray a) {
        for (long r = 0L; r <= this.rowsl / 2L; ++r) {
            long mRow = (this.rowsl - r) % this.rowsl;
            long idx1 = r * this.columnsl;
            long idx2 = mRow * this.columnsl;
            for (long c = 0L; c <= this.columnsl / 2L; ++c) {
                long mCol = (this.columnsl - c) % this.columnsl;
                double A2 = a.getDouble(idx1 + c);
                double B = a.getDouble(idx2 + c);
                double C2 = a.getDouble(idx1 + mCol);
                double D = a.getDouble(idx2 + mCol);
                double E = (A2 + D - (B + C2)) / 2.0;
                a.setDouble(idx1 + c, A2 - E);
                a.setDouble(idx2 + c, B + E);
                a.setDouble(idx1 + mCol, C2 + E);
                a.setDouble(idx2 + mCol, D - E);
            }
        }
    }

    private void yTransform(double[][] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                double A2 = a[r][c];
                double B = a[mRow][c];
                double C2 = a[r][mCol];
                double D = a[mRow][mCol];
                double E = (A2 + D - (B + C2)) / 2.0;
                a[r][c] = A2 - E;
                a[mRow][c] = B + E;
                a[r][mCol] = C2 + E;
                a[mRow][mCol] = D - E;
            }
        }
    }
}

