/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.iotdb.library.drepair.util.ValueRepair;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.RowIterator;

public class Screen
extends ValueRepair {
    private double smin;
    private double smax;
    private double w;

    public Screen(RowIterator dataIterator) throws Exception {
        super(dataIterator);
        this.setParameters();
    }

    private void setParameters() {
        double[] speed = Util.speed(this.original, this.time);
        Median median = new Median();
        double mid = median.evaluate(speed);
        double sigma = Util.mad(speed);
        this.smax = mid + 3.0 * sigma;
        this.smin = mid - 3.0 * sigma;
        double[] interval = Util.variation(this.time);
        this.w = 5.0 * median.evaluate(interval);
    }

    @Override
    public void repair() {
        ArrayList<Pair<Long, Double>> ans = new ArrayList<Pair<Long, Double>>();
        ans.add(Pair.of(this.time[0], this.original[0]));
        int startIndex = 0;
        for (int i = 1; i < this.n; ++i) {
            ans.add(Pair.of(this.time[i], this.original[i]));
            while ((double)ans.get(startIndex).getLeft().longValue() + this.w < (double)ans.get(i).getLeft().longValue()) {
                this.local(ans, startIndex);
                ++startIndex;
            }
        }
        while (startIndex < this.n) {
            this.local(ans, startIndex);
            ++startIndex;
        }
        int k = 0;
        for (Pair<Long, Double> p : ans) {
            this.repaired[k] = p.getRight();
            ++k;
        }
    }

    private double getMedian(ArrayList<Pair<Long, Double>> list, int index) {
        int m4 = 0;
        while (index + m4 + 1 < list.size() && (double)list.get(index + m4 + 1).getLeft().longValue() <= (double)list.get(index).getLeft().longValue() + this.w) {
            ++m4;
        }
        double[] x = new double[2 * m4 + 1];
        x[0] = list.get(index).getRight();
        for (int i = 1; i <= m4; ++i) {
            x[i] = list.get(index + i).getRight() + this.smin * (double)(list.get(index).getLeft() - list.get(index + i).getLeft());
            x[i + m4] = list.get(index + i).getRight() + this.smax * (double)(list.get(index).getLeft() - list.get(index + i).getLeft());
        }
        Arrays.sort(x);
        return x[m4];
    }

    private double getRepairedValue(ArrayList<Pair<Long, Double>> list, int index, double mid) {
        double xmin = list.get(index - 1).getRight() + this.smin * (double)(list.get(index).getLeft() - list.get(index - 1).getLeft());
        double xmax = list.get(index - 1).getRight() + this.smax * (double)(list.get(index).getLeft() - list.get(index - 1).getLeft());
        double temp = mid;
        temp = Math.min(xmax, temp);
        temp = Math.max(xmin, temp);
        return temp;
    }

    private void local(ArrayList<Pair<Long, Double>> list, int index) {
        double mid = this.getMedian(list, index);
        if (index == 0) {
            list.set(index, Pair.of(list.get(index).getLeft(), mid));
        } else {
            double temp = this.getRepairedValue(list, index, mid);
            list.set(index, Pair.of(list.get(index).getLeft(), temp));
        }
    }

    public void setSmin(double smin) {
        this.smin = smin;
    }

    public void setSmax(double smax) {
        this.smax = smax;
    }

    public void setW(int w) {
        this.w = w;
    }
}

