/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceType;
import org.apache.tsfile.file.metadata.IDeviceID;

public class DataDriverContext
extends DriverContext {
    private List<IFullPath> paths = new ArrayList<IFullPath>();
    private QueryDataSourceType queryDataSourceType = null;
    private Map<IDeviceID, DeviceContext> deviceIDToContext = null;
    private List<DataSourceOperator> sourceOperators = new ArrayList<DataSourceOperator>();

    public DataDriverContext(FragmentInstanceContext fragmentInstanceContext, int pipelineId) {
        super(fragmentInstanceContext, pipelineId);
    }

    public DataDriverContext(DataDriverContext parentContext, int pipelineId) {
        super(parentContext.getFragmentInstanceContext(), pipelineId);
    }

    public void setQueryDataSourceType(QueryDataSourceType queryDataSourceType) {
        this.queryDataSourceType = queryDataSourceType;
    }

    public void setDeviceIDToContext(Map<IDeviceID, DeviceContext> deviceIDToContext) {
        this.deviceIDToContext = deviceIDToContext;
    }

    public void clearDeviceIDToContext() {
        this.deviceIDToContext = null;
    }

    public void addPath(IFullPath path) {
        this.paths.add(path);
    }

    public void addSourceOperator(DataSourceOperator sourceOperator) {
        this.sourceOperators.add(sourceOperator);
    }

    public List<IFullPath> getPaths() {
        return this.paths;
    }

    public Map<IDeviceID, DeviceContext> getDeviceIDToContext() {
        return this.deviceIDToContext;
    }

    public Optional<QueryDataSourceType> getQueryDataSourceType() {
        return Optional.ofNullable(this.queryDataSourceType);
    }

    public void clearPaths() {
        this.paths = null;
    }

    public IDataRegionForQuery getDataRegion() {
        return this.getFragmentInstanceContext().getDataRegion();
    }

    public IQueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        return this.getFragmentInstanceContext().getSharedQueryDataSource();
    }

    public List<DataSourceOperator> getSourceOperators() {
        return this.sourceOperators;
    }

    public void clearSourceOperators() {
        this.sourceOperators = null;
    }

    @Override
    public DriverContext createSubDriverContext(int pipelineId) {
        return new DataDriverContext(this, pipelineId);
    }
}

