/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.ratis.metrics.IoTDBMetricRegistry;
import org.apache.iotdb.consensus.ratis.metrics.RefCountingMap;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.util.TimeDuration;

public class MetricRegistryManager
extends MetricRegistries {
    private final RefCountingMap<MetricRegistryInfo, RatisMetricRegistry> registries;
    private final AbstractMetricService service = MetricService.getInstance();

    public MetricRegistryManager() {
        this.registries = new RefCountingMap();
    }

    public void clear() {
        this.registries.values().stream().map(IoTDBMetricRegistry.class::cast).forEach(IoTDBMetricRegistry::removeAll);
        this.registries.clear();
    }

    public RatisMetricRegistry create(MetricRegistryInfo metricRegistryInfo) {
        return this.registries.put(metricRegistryInfo, () -> new IoTDBMetricRegistry(metricRegistryInfo, this.service));
    }

    public boolean remove(MetricRegistryInfo metricRegistryInfo) {
        return this.registries.remove(metricRegistryInfo) == null;
    }

    public Optional<RatisMetricRegistry> get(MetricRegistryInfo metricRegistryInfo) {
        return Optional.ofNullable(this.registries.get(metricRegistryInfo));
    }

    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }

    public Collection<RatisMetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    public void addReporterRegistration(Consumer<RatisMetricRegistry> reporterRegistration, Consumer<RatisMetricRegistry> stopReporter) {
        throw new UnsupportedOperationException("Reporter is disabled from RatisMetricRegistries");
    }

    public void enableJmxReporter() {
        throw new UnsupportedOperationException("JMX Reporter is disabled from RatisMetricRegistries");
    }

    public void enableConsoleReporter(TimeDuration timeDuration) {
        throw new UnsupportedOperationException("Console Reporter is disabled from RatisMetricRegistries");
    }
}

