/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;

public class ScalarParameterSpecification
extends ParameterSpecification {
    private final Type type;
    private final List<Function<Object, String>> checkers;

    private ScalarParameterSpecification(String name, Type type, boolean required, Object defaultValue, List<Function<Object, String>> checkers) {
        super(name, required, Optional.ofNullable(defaultValue));
        this.type = type;
        if (defaultValue != null && !type.checkObjectType(defaultValue)) {
            throw new IllegalArgumentException(String.format("default value %s does not match the declared type: %s", new Object[]{defaultValue, type}));
        }
        this.checkers = checkers;
    }

    public Type getType() {
        return this.type;
    }

    public List<Function<Object, String>> getCheckers() {
        return this.checkers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Type type;
        private boolean required = true;
        private Object defaultValue;
        private final List<Function<Object, String>> checkers = new ArrayList<Function<Object, String>>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder addChecker(Function<Object, String> checker) {
            this.checkers.add(checker);
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.required = false;
            this.defaultValue = defaultValue;
            return this;
        }

        public ScalarParameterSpecification build() {
            return new ScalarParameterSpecification(this.name, this.type, this.required, this.defaultValue, this.checkers);
        }
    }
}

