/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.RegionReplicaSetInfo;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.tsfile.file.metadata.IDeviceID;

public abstract class Partition {
    protected String seriesSlotExecutorName;
    protected int seriesPartitionSlotNum;
    private final SeriesPartitionExecutor executor;

    protected Partition(String seriesSlotExecutorName, int seriesPartitionSlotNum) {
        this.seriesSlotExecutorName = seriesSlotExecutorName;
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor(seriesSlotExecutorName, seriesPartitionSlotNum);
    }

    public TSeriesPartitionSlot calculateDeviceGroupId(IDeviceID deviceID) {
        return this.executor.getSeriesPartitionSlot(deviceID);
    }

    public abstract List<RegionReplicaSetInfo> getDistributionInfo();

    public abstract boolean isEmpty();
}

