/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.read.common.TimeRange;

public class TimePageReader {
    private final PageHeader pageHeader;
    protected Decoder timeDecoder;
    protected ByteBuffer timeBuffer;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;

    public TimePageReader(ByteBuffer pageData, Decoder timeDecoder) {
        this(null, pageData, timeDecoder);
    }

    public TimePageReader(PageHeader pageHeader, ByteBuffer pageData, Decoder timeDecoder) {
        this.timeDecoder = timeDecoder;
        this.pageHeader = pageHeader;
        this.timeBuffer = pageData;
    }

    public boolean hasNextTime() throws IOException {
        return this.timeDecoder.hasNext(this.timeBuffer);
    }

    public long nextTime() {
        return this.timeDecoder.readLong(this.timeBuffer);
    }

    public long[] nextTimeBatch() throws IOException {
        long[] timeBatch = new long[this.pageHeader.getStatistics().getCount()];
        int index = 0;
        while (this.timeDecoder.hasNext(this.timeBuffer)) {
            timeBatch[index++] = this.timeDecoder.readLong(this.timeBuffer);
        }
        return timeBatch;
    }

    public long[] getNextTimeBatch() throws IOException {
        if (this.pageHeader.getStatistics() != null) {
            return this.nextTimeBatch();
        }
        ArrayList<Long> timeList = new ArrayList<Long>();
        while (this.timeDecoder.hasNext(this.timeBuffer)) {
            timeList.add(this.timeDecoder.readLong(this.timeBuffer));
        }
        return timeList.stream().mapToLong(t -> t).toArray();
    }

    public TimeStatistics getStatistics() {
        return (TimeStatistics)this.pageHeader.getStatistics();
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    public boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }
}

