/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class WriteValue
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=668");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=670");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=669");
    private final NodeId nodeId;
    private final UInteger attributeId;
    private final String indexRange;
    private final DataValue value;

    public WriteValue(NodeId nodeId, UInteger attributeId, String indexRange, DataValue value) {
        this.nodeId = nodeId;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public DataValue getValue() {
        return this.value;
    }

    protected WriteValue(WriteValueBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((WriteValueBuilder)b).nodeId;
        this.attributeId = ((WriteValueBuilder)b).attributeId;
        this.indexRange = ((WriteValueBuilder)b).indexRange;
        this.value = ((WriteValueBuilder)b).value;
    }

    public static WriteValueBuilder<?, ?> builder() {
        return new WriteValueBuilderImpl();
    }

    public WriteValueBuilder<?, ?> toBuilder() {
        return new WriteValueBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteValue)) {
            return false;
        }
        WriteValue other = (WriteValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        UInteger this$attributeId = this.getAttributeId();
        UInteger other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        if (this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange)) {
            return false;
        }
        DataValue this$value = this.getValue();
        DataValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WriteValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        UInteger $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        DataValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WriteValue(nodeId=" + this.getNodeId() + ", attributeId=" + this.getAttributeId() + ", indexRange=" + this.getIndexRange() + ", value=" + this.getValue() + ")";
    }

    private static final class WriteValueBuilderImpl
    extends WriteValueBuilder<WriteValue, WriteValueBuilderImpl> {
        private WriteValueBuilderImpl() {
        }

        @Override
        protected WriteValueBuilderImpl self() {
            return this;
        }

        @Override
        public WriteValue build() {
            return new WriteValue(this);
        }
    }

    public static abstract class WriteValueBuilder<C extends WriteValue, B extends WriteValueBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private UInteger attributeId;
        private String indexRange;
        private DataValue value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WriteValueBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(WriteValue instance, WriteValueBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.attributeId(instance.attributeId);
            b.indexRange(instance.indexRange);
            b.value(instance.value);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B attributeId(UInteger attributeId) {
            this.attributeId = attributeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        public B value(DataValue value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "WriteValue.WriteValueBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", attributeId=" + this.attributeId + ", indexRange=" + this.indexRange + ", value=" + this.value + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<WriteValue> {
        @Override
        public Class<WriteValue> getType() {
            return WriteValue.class;
        }

        @Override
        public WriteValue decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            DataValue value = decoder.readDataValue("Value");
            return new WriteValue(nodeId, attributeId, indexRange, value);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, WriteValue value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeUInt32("AttributeId", value.getAttributeId());
            encoder.writeString("IndexRange", value.getIndexRange());
            encoder.writeDataValue("Value", value.getValue());
        }
    }
}

