/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SetTriggeringResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=776");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=778");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=777");
    private final ResponseHeader responseHeader;
    private final StatusCode[] addResults;
    private final DiagnosticInfo[] addDiagnosticInfos;
    private final StatusCode[] removeResults;
    private final DiagnosticInfo[] removeDiagnosticInfos;

    public SetTriggeringResponse(ResponseHeader responseHeader, StatusCode[] addResults, DiagnosticInfo[] addDiagnosticInfos, StatusCode[] removeResults, DiagnosticInfo[] removeDiagnosticInfos) {
        this.responseHeader = responseHeader;
        this.addResults = addResults;
        this.addDiagnosticInfos = addDiagnosticInfos;
        this.removeResults = removeResults;
        this.removeDiagnosticInfos = removeDiagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public StatusCode[] getAddResults() {
        return this.addResults;
    }

    public DiagnosticInfo[] getAddDiagnosticInfos() {
        return this.addDiagnosticInfos;
    }

    public StatusCode[] getRemoveResults() {
        return this.removeResults;
    }

    public DiagnosticInfo[] getRemoveDiagnosticInfos() {
        return this.removeDiagnosticInfos;
    }

    protected SetTriggeringResponse(SetTriggeringResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((SetTriggeringResponseBuilder)b).responseHeader;
        this.addResults = ((SetTriggeringResponseBuilder)b).addResults;
        this.addDiagnosticInfos = ((SetTriggeringResponseBuilder)b).addDiagnosticInfos;
        this.removeResults = ((SetTriggeringResponseBuilder)b).removeResults;
        this.removeDiagnosticInfos = ((SetTriggeringResponseBuilder)b).removeDiagnosticInfos;
    }

    public static SetTriggeringResponseBuilder<?, ?> builder() {
        return new SetTriggeringResponseBuilderImpl();
    }

    public SetTriggeringResponseBuilder<?, ?> toBuilder() {
        return new SetTriggeringResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetTriggeringResponse)) {
            return false;
        }
        SetTriggeringResponse other = (SetTriggeringResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAddResults(), other.getAddResults())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAddDiagnosticInfos(), other.getAddDiagnosticInfos())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRemoveResults(), other.getRemoveResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getRemoveDiagnosticInfos(), other.getRemoveDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetTriggeringResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAddResults());
        result = result * 59 + Arrays.deepHashCode(this.getAddDiagnosticInfos());
        result = result * 59 + Arrays.deepHashCode(this.getRemoveResults());
        result = result * 59 + Arrays.deepHashCode(this.getRemoveDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "SetTriggeringResponse(responseHeader=" + this.getResponseHeader() + ", addResults=" + Arrays.deepToString(this.getAddResults()) + ", addDiagnosticInfos=" + Arrays.deepToString(this.getAddDiagnosticInfos()) + ", removeResults=" + Arrays.deepToString(this.getRemoveResults()) + ", removeDiagnosticInfos=" + Arrays.deepToString(this.getRemoveDiagnosticInfos()) + ")";
    }

    private static final class SetTriggeringResponseBuilderImpl
    extends SetTriggeringResponseBuilder<SetTriggeringResponse, SetTriggeringResponseBuilderImpl> {
        private SetTriggeringResponseBuilderImpl() {
        }

        @Override
        protected SetTriggeringResponseBuilderImpl self() {
            return this;
        }

        @Override
        public SetTriggeringResponse build() {
            return new SetTriggeringResponse(this);
        }
    }

    public static abstract class SetTriggeringResponseBuilder<C extends SetTriggeringResponse, B extends SetTriggeringResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private StatusCode[] addResults;
        private DiagnosticInfo[] addDiagnosticInfos;
        private StatusCode[] removeResults;
        private DiagnosticInfo[] removeDiagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetTriggeringResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SetTriggeringResponse instance, SetTriggeringResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.addResults(instance.addResults);
            b.addDiagnosticInfos(instance.addDiagnosticInfos);
            b.removeResults(instance.removeResults);
            b.removeDiagnosticInfos(instance.removeDiagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B addResults(StatusCode[] addResults) {
            this.addResults = addResults;
            return (B)this.self();
        }

        public B addDiagnosticInfos(DiagnosticInfo[] addDiagnosticInfos) {
            this.addDiagnosticInfos = addDiagnosticInfos;
            return (B)this.self();
        }

        public B removeResults(StatusCode[] removeResults) {
            this.removeResults = removeResults;
            return (B)this.self();
        }

        public B removeDiagnosticInfos(DiagnosticInfo[] removeDiagnosticInfos) {
            this.removeDiagnosticInfos = removeDiagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SetTriggeringResponse.SetTriggeringResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", addResults=" + Arrays.deepToString(this.addResults) + ", addDiagnosticInfos=" + Arrays.deepToString(this.addDiagnosticInfos) + ", removeResults=" + Arrays.deepToString(this.removeResults) + ", removeDiagnosticInfos=" + Arrays.deepToString(this.removeDiagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SetTriggeringResponse> {
        @Override
        public Class<SetTriggeringResponse> getType() {
            return SetTriggeringResponse.class;
        }

        @Override
        public SetTriggeringResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            StatusCode[] addResults = decoder.readStatusCodeArray("AddResults");
            DiagnosticInfo[] addDiagnosticInfos = decoder.readDiagnosticInfoArray("AddDiagnosticInfos");
            StatusCode[] removeResults = decoder.readStatusCodeArray("RemoveResults");
            DiagnosticInfo[] removeDiagnosticInfos = decoder.readDiagnosticInfoArray("RemoveDiagnosticInfos");
            return new SetTriggeringResponse(responseHeader, addResults, addDiagnosticInfos, removeResults, removeDiagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SetTriggeringResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStatusCodeArray("AddResults", value.getAddResults());
            encoder.writeDiagnosticInfoArray("AddDiagnosticInfos", value.getAddDiagnosticInfos());
            encoder.writeStatusCodeArray("RemoveResults", value.getRemoveResults());
            encoder.writeDiagnosticInfoArray("RemoveDiagnosticInfos", value.getRemoveDiagnosticInfos());
        }
    }
}

