/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowsePath
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=543");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=545");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=544");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15190");
    private final NodeId startingNode;
    private final RelativePath relativePath;

    public BrowsePath(NodeId startingNode, RelativePath relativePath) {
        this.startingNode = startingNode;
        this.relativePath = relativePath;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getStartingNode() {
        return this.startingNode;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    protected BrowsePath(BrowsePathBuilder<?, ?> b) {
        super(b);
        this.startingNode = ((BrowsePathBuilder)b).startingNode;
        this.relativePath = ((BrowsePathBuilder)b).relativePath;
    }

    public static BrowsePathBuilder<?, ?> builder() {
        return new BrowsePathBuilderImpl();
    }

    public BrowsePathBuilder<?, ?> toBuilder() {
        return new BrowsePathBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowsePath)) {
            return false;
        }
        BrowsePath other = (BrowsePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$startingNode = this.getStartingNode();
        NodeId other$startingNode = other.getStartingNode();
        if (this$startingNode == null ? other$startingNode != null : !((Object)this$startingNode).equals(other$startingNode)) {
            return false;
        }
        RelativePath this$relativePath = this.getRelativePath();
        RelativePath other$relativePath = other.getRelativePath();
        return !(this$relativePath == null ? other$relativePath != null : !((Object)this$relativePath).equals(other$relativePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowsePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $startingNode = this.getStartingNode();
        result = result * 59 + ($startingNode == null ? 43 : ((Object)$startingNode).hashCode());
        RelativePath $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : ((Object)$relativePath).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BrowsePath(startingNode=" + this.getStartingNode() + ", relativePath=" + this.getRelativePath() + ")";
    }

    private static final class BrowsePathBuilderImpl
    extends BrowsePathBuilder<BrowsePath, BrowsePathBuilderImpl> {
        private BrowsePathBuilderImpl() {
        }

        @Override
        protected BrowsePathBuilderImpl self() {
            return this;
        }

        @Override
        public BrowsePath build() {
            return new BrowsePath(this);
        }
    }

    public static abstract class BrowsePathBuilder<C extends BrowsePath, B extends BrowsePathBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId startingNode;
        private RelativePath relativePath;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowsePathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowsePath instance, BrowsePathBuilder<?, ?> b) {
            b.startingNode(instance.startingNode);
            b.relativePath(instance.relativePath);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B startingNode(NodeId startingNode) {
            this.startingNode = startingNode;
            return (B)this.self();
        }

        public B relativePath(RelativePath relativePath) {
            this.relativePath = relativePath;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowsePath.BrowsePathBuilder(super=" + super.toString() + ", startingNode=" + this.startingNode + ", relativePath=" + this.relativePath + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowsePath> {
        @Override
        public Class<BrowsePath> getType() {
            return BrowsePath.class;
        }

        @Override
        public BrowsePath decode(SerializationContext context, UaDecoder decoder) {
            NodeId startingNode = decoder.readNodeId("StartingNode");
            RelativePath relativePath = (RelativePath)decoder.readStruct("RelativePath", RelativePath.TYPE_ID);
            return new BrowsePath(startingNode, relativePath);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowsePath value) {
            encoder.writeNodeId("StartingNode", value.getStartingNode());
            encoder.writeStruct("RelativePath", (Object)value.getRelativePath(), RelativePath.TYPE_ID);
        }
    }
}

