/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.rpc.subscription.payload.poll.PollFilePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.PollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.PollTabletsPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollRequestType;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPollRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPollResponse.class);
    private final transient short requestType;
    private final transient SubscriptionPollPayload payload;
    private final transient long timeoutMs;
    private final transient long maxBytes;

    public SubscriptionPollRequest(short requestType, SubscriptionPollPayload payload, long timeoutMs, long maxBytes) {
        this.requestType = requestType;
        this.payload = payload;
        this.timeoutMs = timeoutMs;
        this.maxBytes = maxBytes;
    }

    public short getRequestType() {
        return this.requestType;
    }

    public SubscriptionPollPayload getPayload() {
        return this.payload;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public static ByteBuffer serialize(SubscriptionPollRequest request) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                request.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.requestType, (OutputStream)stream);
        this.payload.serialize(stream);
        ReadWriteIOUtils.write((long)this.timeoutMs, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.maxBytes, (OutputStream)stream);
    }

    public static SubscriptionPollRequest deserialize(ByteBuffer buffer) {
        short requestType = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        SubscriptionPollPayload payload = null;
        if (SubscriptionPollRequestType.isValidatedRequestType(requestType)) {
            switch (SubscriptionPollRequestType.valueOf(requestType)) {
                case POLL: {
                    payload = new PollPayload().deserialize(buffer);
                    break;
                }
                case POLL_FILE: {
                    payload = new PollFilePayload().deserialize(buffer);
                    break;
                }
                case POLL_TABLETS: {
                    payload = new PollTabletsPayload().deserialize(buffer);
                    break;
                }
                default: {
                    LOGGER.warn("unexpected request type: {}, payload will be null", (Object)requestType);
                    break;
                }
            }
        } else {
            LOGGER.warn("unexpected request type: {}, payload will be null", (Object)requestType);
        }
        long timeoutMs = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        long maxBytes = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return new SubscriptionPollRequest(requestType, payload, timeoutMs, maxBytes);
    }

    public String toString() {
        return "SubscriptionPollRequest{requestType=" + SubscriptionPollRequestType.valueOf(this.requestType).toString() + ", payload=" + this.payload + ", timeoutMs=" + this.timeoutMs + ", maxBytes=" + this.maxBytes + "}";
    }
}

