/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TAINodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ainode.AINodeClient;
import org.apache.iotdb.commons.client.ainode.AINodeClientManager;
import org.apache.iotdb.commons.model.exception.ModelManagementException;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.model.DropModelState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropModelProcedure
extends AbstractNodeProcedure<DropModelState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropModelProcedure.class);
    private static final int RETRY_THRESHOLD = 1;
    private String modelName;

    public DropModelProcedure() {
    }

    public DropModelProcedure(String modelName) {
        this.modelName = modelName;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropModelState state) {
        block8: {
            if (this.modelName == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case AI_NODE_DROPPED: {
                        LOGGER.info("Start to drop model [{}] on AI Nodes", (Object)this.modelName);
                        this.dropModelOnAINode(env);
                        this.setNextState(DropModelState.CONFIG_NODE_DROPPED);
                        break;
                    }
                    case CONFIG_NODE_DROPPED: {
                        this.dropModelOnConfigNode(env);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown state during executing dropModelProcedure, %s", new Object[]{state}));
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in DropModelProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to drop model [{}], state [{}]", new Object[]{this.modelName, state, e});
                if (this.getCycles() <= 1) break block8;
                this.setFailure(new ProcedureException(String.format("Fail to drop model [%s] at STATE [%s], %s", new Object[]{this.modelName, state, e.getMessage()})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void dropModelOnAINode(ConfigNodeProcedureEnv env) {
        LOGGER.info("Start to drop model file [{}] on AI Node", (Object)this.modelName);
        List<TAINodeConfiguration> aiNodes = env.getConfigManager().getNodeManager().getRegisteredAINodes();
        aiNodes.forEach(aiNode -> {
            int nodeId = aiNode.getLocation().getAiNodeId();
            try (AINodeClient client = (AINodeClient)AINodeClientManager.getInstance().borrowClient((Object)env.getConfigManager().getNodeManager().getRegisteredAINode(nodeId).getLocation().getInternalEndPoint());){
                TSStatus status = client.deleteModel(this.modelName);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Failed to drop model [{}] on AINode [{}], status: {}", new Object[]{this.modelName, nodeId, status.getMessage()});
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to drop model [{}] on AINode [{}], status: {}", new Object[]{this.modelName, nodeId, e.getMessage()});
            }
        });
    }

    private void dropModelOnConfigNode(ConfigNodeProcedureEnv env) {
        try {
            TSStatus response = env.getConfigManager().getConsensusManager().write(new DropModelPlan(this.modelName));
            if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new TException(response.getMessage());
            }
        }
        catch (Exception e) {
            throw new ModelManagementException(String.format("Fail to start training model [%s] on AI Node: %s", this.modelName, e.getMessage()));
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DropModelState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected DropModelState getState(int stateId) {
        return DropModelState.values()[stateId];
    }

    @Override
    protected int getStateId(DropModelState dropModelState) {
        return dropModelState.ordinal();
    }

    @Override
    protected DropModelState getInitialState() {
        return DropModelState.AI_NODE_DROPPED;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_MODEL_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.modelName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof DropModelProcedure) {
            DropModelProcedure thatProc = (DropModelProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.modelName.equals(this.modelName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.modelName});
    }
}

