/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerClassLoader.class);
    private final String libRoot;

    public TriggerClassLoader(String libRoot) throws IOException {
        super(new URL[0]);
        this.libRoot = libRoot;
        LOGGER.info("Trigger lib root: {}", (Object)libRoot);
        this.addURLs();
    }

    private void addURLs() throws IOException {
        try (Stream<Path> pathStream = Files.walk(SystemFileFactory.INSTANCE.getFile(this.libRoot).toPath(), new FileVisitOption[0]);){
            for (Path path2 : pathStream.filter(path -> !path.toFile().isDirectory()).collect(Collectors.toList())) {
                super.addURL(path2.toUri().toURL());
            }
        }
    }
}

