/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.tsfile.file.metadata.IDeviceID;

public class TsFileResourceCandidate {
    public TsFileResource resource;
    public boolean selected;
    public boolean isValidCandidate;
    private ArrayDeviceTimeIndex deviceTimeIndex;
    private boolean hasDetailedDeviceInfo;
    private final CompactionScheduleContext compactionScheduleContext;

    public TsFileResourceCandidate(TsFileResource tsFileResource, CompactionScheduleContext context) {
        this.resource = tsFileResource;
        this.selected = false;
        this.isValidCandidate = tsFileResource.getStatus() == TsFileResourceStatus.NORMAL && tsFileResource.getTsFileRepairStatus() == TsFileRepairStatus.NORMAL;
        this.compactionScheduleContext = context;
    }

    public boolean unsealed() {
        return this.resource.getStatus() == TsFileResourceStatus.UNCLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeviceInfos() throws IOException {
        boolean canCacheDeviceInfo;
        boolean bl = canCacheDeviceInfo = this.resource.getStatus() != TsFileResourceStatus.UNCLOSED;
        if (this.deviceTimeIndex == null && this.compactionScheduleContext != null) {
            this.deviceTimeIndex = this.compactionScheduleContext.getResourceDeviceInfo(this.resource);
        }
        if (this.deviceTimeIndex != null) {
            this.hasDetailedDeviceInfo = true;
            return;
        }
        ITimeIndex timeIndex = this.resource.getTimeIndex();
        if (timeIndex instanceof ArrayDeviceTimeIndex) {
            if (this.resource.isClosed()) {
                this.deviceTimeIndex = (ArrayDeviceTimeIndex)timeIndex;
            } else {
                this.deviceTimeIndex = new ArrayDeviceTimeIndex();
                for (IDeviceID device : ((ArrayDeviceTimeIndex)timeIndex).getDevices()) {
                    this.deviceTimeIndex.updateStartTime(device, timeIndex.getStartTime(device).get());
                    this.deviceTimeIndex.updateEndTime(device, timeIndex.getEndTime(device).get());
                }
            }
        } else {
            this.resource.readLock();
            try {
                if (!this.resource.resourceFileExists()) {
                    this.hasDetailedDeviceInfo = false;
                    this.deviceTimeIndex = new ArrayDeviceTimeIndex();
                    return;
                }
                this.deviceTimeIndex = CompactionUtils.buildDeviceTimeIndex(this.resource);
            }
            finally {
                this.resource.readUnlock();
            }
        }
        this.hasDetailedDeviceInfo = true;
        if (this.compactionScheduleContext != null && canCacheDeviceInfo) {
            this.compactionScheduleContext.addResourceDeviceTimeIndex(this.resource, this.deviceTimeIndex);
        }
    }

    public void markAsSelected() {
        this.selected = true;
    }

    public Iterator<DeviceInfo> getDeviceInfoIterator() throws IOException {
        this.prepareDeviceInfos();
        return new Iterator<DeviceInfo>(){
            private final Iterator<IDeviceID> deviceIterator;
            {
                this.deviceIterator = TsFileResourceCandidate.this.deviceTimeIndex.getDevices().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.deviceIterator.hasNext();
            }

            @Override
            public DeviceInfo next() {
                IDeviceID deviceId = this.deviceIterator.next();
                return new DeviceInfo(deviceId, TsFileResourceCandidate.this.deviceTimeIndex.getStartTime(deviceId).get(), TsFileResourceCandidate.this.deviceTimeIndex.getEndTime(deviceId).get());
            }
        };
    }

    public Set<IDeviceID> getDevices() throws IOException {
        this.prepareDeviceInfos();
        return this.deviceTimeIndex.getDevices();
    }

    public DeviceInfo getDeviceInfoById(IDeviceID deviceId) throws IOException {
        this.prepareDeviceInfos();
        return new DeviceInfo(deviceId, this.deviceTimeIndex.getStartTime(deviceId).get(), this.deviceTimeIndex.getEndTime(deviceId).get());
    }

    public boolean containsDevice(IDeviceID deviceId) throws IOException {
        this.prepareDeviceInfos();
        return !this.deviceTimeIndex.definitelyNotContains(deviceId);
    }

    public boolean hasDetailedDeviceInfo() throws IOException {
        this.prepareDeviceInfos();
        return this.hasDetailedDeviceInfo;
    }

    public boolean mayHasOverlapWithUnseqFile(DeviceInfo unseqFileDeviceInfo) throws IOException {
        this.prepareDeviceInfos();
        long endTime = this.containsDevice(unseqFileDeviceInfo.deviceId) ? this.getDeviceInfoById((IDeviceID)unseqFileDeviceInfo.deviceId).endTime : this.resource.getFileEndTime();
        return unseqFileDeviceInfo.startTime <= endTime;
    }
}

