/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionTableSchema;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.write.schema.Schema;

public class CompactionTableSchemaCollector {
    private CompactionTableSchemaCollector() {
    }

    public static List<Schema> collectSchema(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, Map<TsFileResource, TsFileSequenceReader> readerMap) throws IOException {
        ArrayList<Schema> targetSchemas = new ArrayList<Schema>(seqFiles.size());
        Schema schema = CompactionTableSchemaCollector.collectSchema(Stream.concat(seqFiles.stream(), unseqFiles.stream()).collect(Collectors.toList()), readerMap);
        targetSchemas.add(schema);
        for (int i = 1; i < seqFiles.size(); ++i) {
            Schema copySchema = CompactionTableSchemaCollector.copySchema(schema);
            targetSchemas.add(copySchema);
        }
        return targetSchemas;
    }

    public static Schema copySchema(Schema source) {
        Schema copySchema = new Schema();
        for (TableSchema tableSchema : source.getTableSchemaMap().values()) {
            copySchema.registerTableSchema((TableSchema)((CompactionTableSchema)tableSchema).copy());
        }
        return copySchema;
    }

    public static Schema collectSchema(List<TsFileResource> sourceFiles, Map<TsFileResource, TsFileSequenceReader> readerMap) throws IOException {
        Schema targetSchema = new Schema();
        HashMap<String, CompactionTableSchema> targetTableSchemaMap = new HashMap<String, CompactionTableSchema>();
        for (TsFileResource resource : sourceFiles) {
            TsFileSequenceReader reader = readerMap.get(resource);
            Map tableSchemaMap = reader.getTableSchemaMap();
            if (tableSchemaMap == null) continue;
            for (Map.Entry entry : tableSchemaMap.entrySet()) {
                String tableName = (String)entry.getKey();
                TableSchema currentTableSchema = (TableSchema)entry.getValue();
                if (CompactionTableSchemaCollector.isTreeModel(currentTableSchema)) continue;
                CompactionTableSchema collectedTableSchema = (CompactionTableSchema)((Object)targetTableSchemaMap.get(tableName));
                if (collectedTableSchema == null) {
                    collectedTableSchema = new CompactionTableSchema(tableName);
                    targetTableSchemaMap.put(tableName, collectedTableSchema);
                }
                collectedTableSchema.merge(currentTableSchema);
            }
        }
        targetTableSchemaMap.values().forEach(arg_0 -> ((Schema)targetSchema).registerTableSchema(arg_0));
        return targetSchema;
    }

    private static boolean isTreeModel(TableSchema tableSchema) {
        return tableSchema == null;
    }
}

