/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionSourceFileDeletedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.IInnerCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.tsfile.utils.TsFileUtils;

public class InnerSpaceCompactionTask
extends AbstractCompactionTask {
    protected InnerCompactionTaskFilesView filesView;
    protected File logFile;
    protected boolean[] isHoldingWriteLock;
    protected AbstractInnerSpaceEstimator innerSpaceEstimator;

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, ICompactionPerformer performer, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, serialId);
        this.filesView = new InnerCompactionTaskFilesView(selectedTsFileResourceList, sequence);
        this.performer = performer;
        this.hashCode = this.hashCode();
        this.createSummary();
    }

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, List<TsFileResource> skippedTsFileResourceList, boolean sequence, ICompactionPerformer performer, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, serialId);
        this.filesView = new InnerCompactionTaskFilesView(selectedTsFileResourceList, skippedTsFileResourceList, sequence);
        this.performer = performer;
        this.hashCode = this.hashCode();
        this.createSummary();
    }

    public InnerSpaceCompactionTask(String databaseName, String dataRegionId, TsFileManager tsFileManager, File logFile) {
        super(databaseName, dataRegionId, 0L, tsFileManager, 0L);
        this.logFile = logFile;
        this.needRecoverTaskInfoFromLogFile = true;
        this.filesView = new InnerCompactionTaskFilesView();
    }

    protected void prepare() throws IOException, DiskSpaceInsufficientException {
        this.calculateSourceFilesAndTargetFiles();
        CompactionUtils.prepareCompactionModFiles(this.filesView.targetFilesInPerformer, this.filesView.sourceFilesInLog);
        this.isHoldingWriteLock = new boolean[this.filesView.sourceFilesInLog.size()];
        Arrays.fill(this.isHoldingWriteLock, false);
        String dataDirectory = this.filesView.sourceFilesInCompactionPerformer.get(0).getTsFile().getParent();
        String logSuffix = CompactionLogger.getLogSuffix(this.isSequence() ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ);
        this.logFile = new File(dataDirectory + File.separator + this.filesView.targetFilesInLog.get(0).getTsFile().getName() + logSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        if (this.getCompactionTaskType() != CompactionTaskType.REPAIR && (this.filesView.sequence && !IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction() || !this.filesView.sequence && !IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction())) {
            return true;
        }
        if (this.compactionConfigVersion < CompactionTaskManager.getInstance().getCurrentCompactionConfigVersion()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        this.recoverMemoryStatus = true;
        LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task starts with {} files, total file size is {} MB, estimated memory cost is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.filesView.sequence ? "Sequence" : "Unsequence", this.filesView.sourceFilesInCompactionPerformer.size(), this.filesView.selectedFileSize / 1024L / 1024L, this.memoryCost == 0L ? 0.0 : (double)this.memoryCost / 1024.0 / 1024.0});
        boolean isSuccess = true;
        try {
            this.prepare();
            try (SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(this.logFile);){
                compactionLogger.logSourceFiles(this.filesView.sourceFilesInLog);
                compactionLogger.logTargetFiles(this.filesView.targetFilesInLog);
                compactionLogger.force();
                LOGGER.info("{}-{} [Compaction] compaction with selected files {}, skipped files {}", new Object[]{this.storageGroupName, this.dataRegionId, this.filesView.sourceFilesInCompactionPerformer, this.filesView.skippedSourceFiles});
                this.compact(compactionLogger);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task finishes successfully, target files are {},time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, this.filesView.sequence ? "Sequence" : "Unsequence", this.filesView.targetFilesInLog, String.format("%.2f", costTime), String.format("%.2f", (double)this.filesView.selectedFileSize / 1024.0 / 1024.0 / costTime), this.summary});
            }
        }
        catch (Exception e) {
            isSuccess = false;
            this.handleException(LOGGER, e);
            this.recover();
        }
        finally {
            this.releaseAllLocks();
            try {
                if (this.logFile != null) {
                    Files.deleteIfExists(this.logFile.toPath());
                }
            }
            catch (IOException e) {
                this.handleException(LOGGER, e);
            }
            for (TsFileResource targetTsFileResource : this.filesView.targetFilesInLog) {
                targetTsFileResource.setStatus(TsFileResourceStatus.NORMAL);
            }
        }
        return isSuccess;
    }

    protected void calculateSourceFilesAndTargetFiles() throws DiskSpaceInsufficientException, IOException {
        TsFileResource resource2;
        TsFileResource resource1;
        LinkedList<TsFileResource> availablePositionForTargetFiles = new LinkedList<TsFileResource>();
        for (int i = this.filesView.sourceFilesInCompactionPerformer.size() - 1; i >= 0 && (resource1 = this.filesView.sourceFilesInCompactionPerformer.get(i)) == (resource2 = this.filesView.sortedAllSourceFilesInTask.get(this.filesView.sortedAllSourceFilesInTask.size() - 1 - availablePositionForTargetFiles.size())); --i) {
            availablePositionForTargetFiles.addFirst(resource1);
        }
        int requiredPositionNum = Math.min((int)(this.filesView.selectedFileSize / IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize()) + 1, this.filesView.sortedAllSourceFilesInTask.size());
        boolean needToAdjustSourceFilesPosition = requiredPositionNum > availablePositionForTargetFiles.size();
        this.filesView.targetFilesInLog = new ArrayList<TsFileResource>();
        this.filesView.sourceFilesInLog = needToAdjustSourceFilesPosition ? this.filesView.sortedAllSourceFilesInTask : this.filesView.sourceFilesInCompactionPerformer;
        this.calculateRenamedTargetFiles(needToAdjustSourceFilesPosition);
        this.filesView.targetFilesInPerformer = needToAdjustSourceFilesPosition ? TsFileNameGenerator.getNewInnerCompactionTargetFileResources(this.filesView.sortedAllSourceFilesInTask.subList(this.filesView.renamedTargetFiles.size(), Math.min(this.filesView.renamedTargetFiles.size() + requiredPositionNum, this.filesView.sortedAllSourceFilesInTask.size())), this.filesView.sequence) : TsFileNameGenerator.getNewInnerCompactionTargetFileResources(availablePositionForTargetFiles.subList(0, requiredPositionNum), this.filesView.sequence);
        this.filesView.targetFilesInLog = new ArrayList<TsFileResource>(this.filesView.targetFilesInPerformer.size() + this.filesView.renamedTargetFiles.size());
        this.filesView.targetFilesInLog.addAll(this.filesView.renamedTargetFiles);
        this.filesView.targetFilesInLog.addAll(this.filesView.targetFilesInPerformer);
    }

    private void calculateRenamedTargetFiles(boolean needAdjustSourceFilePosition) throws IOException {
        this.filesView.renamedTargetFiles = new ArrayList<TsFileResource>();
        if (!needAdjustSourceFilePosition) {
            return;
        }
        for (int i = 0; i < this.filesView.skippedSourceFiles.size(); ++i) {
            TsFileResource resource = this.filesView.sortedAllSourceFilesInTask.get(i);
            File file = resource.getTsFile();
            File skippedSourceFile = this.filesView.skippedSourceFiles.get(i).getTsFile();
            TsFileNameGenerator.TsFileName skippedSourceFileName = TsFileNameGenerator.getTsFileName(skippedSourceFile.getName());
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(file.getName());
            String newFileName = String.format("%s-%s-%s-%s.tsfile", tsFileName.getTime(), tsFileName.getVersion(), skippedSourceFileName.getInnerCompactionCnt(), tsFileName.getCrossCompactionCnt() + 1);
            TsFileResource renamedTargetFile = new TsFileResource(new File(skippedSourceFile.getParentFile().getPath() + File.separator + newFileName), TsFileResourceStatus.COMPACTING);
            this.filesView.renamedTargetFiles.add(renamedTargetFile);
        }
    }

    protected void compact(SimpleCompactionLogger compactionLogger) throws Exception {
        this.performer.setSourceFiles(this.filesView.sourceFilesInCompactionPerformer);
        this.performer.setTargetFiles(this.filesView.targetFilesInPerformer);
        this.performer.setSummary(this.summary);
        this.performer.perform();
        this.prepareTargetFiles();
        if (Thread.currentThread().isInterrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
        }
        this.validateCompactionResult(this.filesView.sequence ? this.filesView.sourceFilesInLog : Collections.emptyList(), this.filesView.sequence ? Collections.emptyList() : this.filesView.sourceFilesInLog, this.filesView.targetFilesInLog);
        this.tsFileManager.replace(this.filesView.sequence ? this.filesView.sourceFilesInLog : Collections.emptyList(), this.filesView.sequence ? Collections.emptyList() : this.filesView.sourceFilesInLog, this.filesView.targetFilesInLog, this.timePartition);
        for (TsFileResource targetTsFileResource : this.filesView.targetFilesInLog) {
            if (!targetTsFileResource.isDeleted()) {
                CompactionUtils.addFilesToFileMetrics(targetTsFileResource);
                continue;
            }
            compactionLogger.logEmptyTargetFile(targetTsFileResource);
            compactionLogger.force();
            targetTsFileResource.remove();
        }
        for (int i = 0; i < this.filesView.sourceFilesInLog.size(); ++i) {
            this.filesView.sourceFilesInLog.get(i).writeLock();
            this.isHoldingWriteLock[i] = true;
        }
        CompactionUtils.deleteSourceTsFileAndUpdateFileMetrics(this.filesView.sourceFilesInLog, this.filesView.sequence);
        CompactionMetrics.getInstance().recordSummaryInfo(this.summary);
    }

    protected void prepareTargetFiles() throws IOException {
        CompactionUtils.updateProgressIndexAndMark(this.filesView.targetFilesInPerformer, this.filesView.sequence ? this.filesView.sourceFilesInCompactionPerformer : Collections.emptyList(), this.filesView.sequence ? Collections.emptyList() : this.filesView.sourceFilesInCompactionPerformer);
        for (int i = 0; i < this.filesView.renamedTargetFiles.size(); ++i) {
            TsFileResource oldFile = this.filesView.skippedSourceFiles.get(i);
            TsFileResource newFile = this.filesView.renamedTargetFiles.get(i);
            oldFile.link(newFile);
            newFile.deserialize();
        }
        CompactionUtils.moveTargetFile(this.filesView.targetFilesInPerformer, this.getCompactionTaskType(), this.storageGroupName + "-" + this.dataRegionId);
        CompactionUtils.combineModsInInnerCompaction(this.filesView.sourceFilesInCompactionPerformer, this.filesView.targetFilesInPerformer);
    }

    @Override
    public void recover() {
        try {
            if (this.needRecoverTaskInfoFromLogFile) {
                this.recoverTaskInfoFromLogFile();
            }
            if (this.shouldRollback()) {
                this.rollback();
            } else {
                this.finishTask();
            }
        }
        catch (Exception e) {
            this.handleRecoverException(e);
        }
    }

    private void recoverTaskInfoFromLogFile() throws IOException {
        CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.logFile);
        logAnalyzer.analyze();
        List<TsFileIdentifier> sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
        List<TsFileIdentifier> targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
        List<TsFileIdentifier> deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
        ArrayList<TsFileResource> selectedTsFileResourceList = new ArrayList<TsFileResource>();
        sourceFileIdentifiers.forEach(f -> selectedTsFileResourceList.add(new TsFileResource(f.getFileFromDataDirs())));
        this.filesView.setSourceFilesForRecover(selectedTsFileResourceList);
        this.recoverTargetResource(targetFileIdentifiers, deletedTargetFileIdentifiers);
        this.taskStage = logAnalyzer.getTaskStage();
    }

    protected void recoverTargetResource(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> deletedTargetFileIdentifiers) {
        ArrayList<TsFileResource> targetResources = new ArrayList<TsFileResource>(targetFileIdentifiers.size());
        for (TsFileIdentifier targetIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = targetIdentifier.getFileFromDataDirsIfAnyAdjuvantFileExists();
            targetIdentifier.setFilename(targetIdentifier.getFilename().replace(CompactionUtils.getTmpFileSuffix(this.getCompactionTaskType()), ".tsfile"));
            File targetFile = targetIdentifier.getFileFromDataDirsIfAnyAdjuvantFileExists();
            TsFileResource resource = tmpTargetFile != null ? new TsFileResource(tmpTargetFile) : (targetFile != null ? new TsFileResource(targetFile) : new TsFileResource(new File(targetIdentifier.getFilePath())));
            targetResources.add(resource);
            if (!deletedTargetFileIdentifiers.contains(targetIdentifier)) continue;
            resource.forceMarkDeleted();
        }
        this.filesView.setTargetFileForRecover(targetResources);
    }

    protected void rollback() throws IOException {
        List<TsFileResource> targetFiles;
        List<TsFileResource> list = targetFiles = this.filesView.targetFilesInLog == null ? Collections.emptyList() : this.filesView.targetFilesInLog;
        if (this.recoverMemoryStatus) {
            this.replaceTsFileInMemory(targetFiles, this.filesView.sourceFilesInLog);
        }
        this.deleteCompactionModsFile(this.filesView.sortedAllSourceFilesInTask);
        for (TsFileResource targetTsFileResource : targetFiles) {
            if (targetTsFileResource == null || this.deleteTsFileOnDisk(targetTsFileResource)) continue;
            throw new CompactionRecoverException(String.format("failed to delete target file %s", targetTsFileResource));
        }
    }

    protected void finishTask() throws IOException {
        for (TsFileResource targetTsFileResource : this.filesView.targetFilesInLog) {
            if (targetTsFileResource.isDeleted()) {
                if (targetTsFileResource.remove()) continue;
                throw new CompactionRecoverException(String.format("failed to delete empty target file %s", targetTsFileResource));
            }
            File targetFile = targetTsFileResource.getTsFile();
            if (targetFile == null || !targetFile.exists() || !TsFileUtils.isTsFileComplete((File)targetTsFileResource.getTsFile())) {
                throw new CompactionRecoverException(String.format("Target file is not completed. %s", targetFile));
            }
            if (!this.recoverMemoryStatus) continue;
            targetTsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        }
        if (!this.deleteTsFilesOnDisk(this.filesView.sourceFilesInLog)) {
            throw new CompactionRecoverException("source files cannot be deleted successfully");
        }
        if (this.recoverMemoryStatus) {
            FileMetrics.getInstance().deleteTsFile(this.filesView.sequence, this.filesView.sourceFilesInLog);
        }
    }

    protected boolean shouldRollback() {
        return this.checkAllSourceFileExists(this.filesView.sourceFilesInLog);
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        InnerSpaceCompactionTask task = (InnerSpaceCompactionTask)otherTask;
        return this.getAllSourceTsFiles().equals(task.getAllSourceTsFiles()) && this.performer.getClass().isInstance(task.performer);
    }

    @Override
    public List<TsFileResource> getAllSourceTsFiles() {
        return this.filesView.sortedAllSourceFilesInTask;
    }

    public List<TsFileResource> getSelectedTsFileResourceList() {
        return this.filesView.sourceFilesInCompactionPerformer;
    }

    public double getAvgCompactionCount() {
        return (double)this.filesView.sumOfCompactionCount / (double)this.filesView.sourceFilesInCompactionPerformer.size();
    }

    public double getAvgFileSize() {
        return (double)this.filesView.selectedFileSize / (double)this.filesView.sourceFilesInCompactionPerformer.size();
    }

    @TestOnly
    public void setTargetTsFileResource(TsFileResource targetTsFileResource) {
        this.filesView.setTargetFileForRecover(targetTsFileResource);
    }

    public boolean isSequence() {
        return this.filesView.sequence;
    }

    @Override
    public long getSelectedFileSize() {
        return this.filesView.selectedFileSize;
    }

    public int getSumOfCompactionCount() {
        return this.filesView.sumOfCompactionCount;
    }

    public long getMaxFileVersion() {
        return this.filesView.maxFileVersion;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task file num is " + this.filesView.sourceFilesInCompactionPerformer.size() + ", files is " + this.filesView.sourceFilesInCompactionPerformer + ", total compaction count is " + this.filesView.sumOfCompactionCount;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((InnerSpaceCompactionTask)other);
    }

    protected void releaseAllLocks() {
        for (int i = 0; i < this.filesView.sourceFilesInLog.size(); ++i) {
            TsFileResource resource = this.filesView.sourceFilesInLog.get(i);
            if (!this.isHoldingWriteLock[i]) continue;
            resource.writeUnlock();
        }
    }

    @Override
    public long getEstimatedMemoryCost() {
        if (this.innerSpaceEstimator == null) {
            this.innerSpaceEstimator = ((IInnerCompactionPerformer)this.performer).getInnerSpaceEstimator().orElse(null);
        }
        if (this.innerSpaceEstimator != null && this.memoryCost == 0L) {
            try {
                this.memoryCost = CompactionEstimateUtils.shouldUseRoughEstimatedResult(this.roughMemoryCost) ? this.roughMemoryCost : this.innerSpaceEstimator.estimateInnerCompactionMemory(this.filesView.sourceFilesInCompactionPerformer);
            }
            catch (CompactionSourceFileDeletedException e) {
                this.innerSpaceEstimator.cleanup();
                return -1L;
            }
            catch (Exception e) {
                if (e instanceof StopReadTsFileByInterruptException || Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return -1L;
                }
                this.innerSpaceEstimator.cleanup();
                if (!this.tsFileManager.isAllowCompaction()) {
                    return -1L;
                }
                LOGGER.error("Meet error when estimate inner compaction memory", (Throwable)e);
                return -1L;
            }
        }
        return this.memoryCost;
    }

    @Override
    public int getProcessedFileNum() {
        return this.filesView.sourceFilesInCompactionPerformer.size();
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }

    @Override
    public CompactionTaskType getCompactionTaskType() {
        if (this.filesView.sequence) {
            return CompactionTaskType.INNER_SEQ;
        }
        return CompactionTaskType.INNER_UNSEQ;
    }

    @Override
    public long getCompactionConfigVersion() {
        return this.compactionConfigVersion;
    }

    @Override
    public void setCompactionConfigVersion(long compactionConfigVersion) {
        this.compactionConfigVersion = Math.min(this.compactionConfigVersion, compactionConfigVersion);
    }

    protected static class InnerCompactionTaskFilesView {
        protected List<TsFileResource> sortedAllSourceFilesInTask;
        protected List<TsFileResource> sourceFilesInCompactionPerformer;
        protected List<TsFileResource> skippedSourceFiles;
        protected boolean sequence;
        protected List<TsFileResource> sourceFilesInLog;
        protected List<TsFileResource> targetFilesInLog;
        protected List<TsFileResource> targetFilesInPerformer;
        protected List<TsFileResource> renamedTargetFiles;
        protected long selectedFileSize;
        protected int sumOfCompactionCount;
        protected long maxFileVersion;
        protected int maxCompactionCount;

        protected InnerCompactionTaskFilesView(List<TsFileResource> selectedFiles, List<TsFileResource> skippedFiles, boolean sequence) {
            this.sourceFilesInCompactionPerformer = selectedFiles;
            this.skippedSourceFiles = skippedFiles;
            this.sequence = sequence;
            this.sortedAllSourceFilesInTask = Stream.concat(this.sourceFilesInCompactionPerformer.stream(), this.skippedSourceFiles.stream()).sorted(TsFileResource::compareFileName).collect(Collectors.toList());
            this.collectSelectedFilesInfo();
        }

        protected InnerCompactionTaskFilesView(List<TsFileResource> selectedFiles, boolean sequence) {
            this(selectedFiles, Collections.emptyList(), sequence);
            this.sourceFilesInLog = selectedFiles;
        }

        protected InnerCompactionTaskFilesView() {
        }

        private void collectSelectedFilesInfo() {
            this.selectedFileSize = 0L;
            this.sumOfCompactionCount = 0;
            this.maxFileVersion = -1L;
            this.maxCompactionCount = -1;
            if (this.sourceFilesInCompactionPerformer == null) {
                return;
            }
            for (TsFileResource resource : this.sourceFilesInCompactionPerformer) {
                try {
                    this.selectedFileSize += resource.getTsFileSize();
                    TsFileNameGenerator.TsFileName fileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
                    this.sumOfCompactionCount += fileName.getInnerCompactionCnt();
                    if (fileName.getInnerCompactionCnt() > this.maxCompactionCount) {
                        this.maxCompactionCount = fileName.getInnerCompactionCnt();
                    }
                    if (fileName.getVersion() <= this.maxFileVersion) continue;
                    this.maxFileVersion = fileName.getVersion();
                }
                catch (IOException e) {
                    AbstractCompactionTask.LOGGER.warn("Fail to get the tsfile name of {}", (Object)resource.getTsFile(), (Object)e);
                }
            }
        }

        protected void setSourceFilesForRecover(List<TsFileResource> sourceFiles) {
            this.sourceFilesInCompactionPerformer = sourceFiles;
            this.sourceFilesInLog = sourceFiles;
            this.sortedAllSourceFilesInTask = sourceFiles;
        }

        protected void setTargetFileForRecover(TsFileResource resource) {
            this.targetFilesInLog = Collections.singletonList(resource);
            this.targetFilesInPerformer = this.targetFilesInLog;
            this.renamedTargetFiles = Collections.emptyList();
        }

        protected void setTargetFileForRecover(List<TsFileResource> resources) {
            this.targetFilesInLog = resources;
            this.targetFilesInPerformer = resources;
            this.renamedTargetFiles = Collections.emptyList();
        }
    }
}

