/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ConsensusMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String CONSENSUS = "Consensus";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getConsensusMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), CONSENSUS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getConsensusMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), CONSENSUS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), CONSENSUS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), CONSENSUS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
    }

    public static ConsensusMemoryMetrics getInstance() {
        return ConsensusMemoryMetricsHolder.INSTANCE;
    }

    private static class ConsensusMemoryMetricsHolder {
        private static final ConsensusMemoryMetrics INSTANCE = new ConsensusMemoryMetrics();

        private ConsensusMemoryMetricsHolder() {
        }
    }
}

