/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.logfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.IDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FakeCRC32Deserializer<T>
implements IDeserializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeCRC32Deserializer.class);
    private static final InputStream EMPTY_INPUT_STREAM_PLACE_HOLDER = new ByteArrayInputStream(new byte[0]);
    private final IDeserializer<T> deserializer;
    private final ConfigurableDataInputStream dataInputStream = new ConfigurableDataInputStream(EMPTY_INPUT_STREAM_PLACE_HOLDER);

    public FakeCRC32Deserializer(IDeserializer<T> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public T deserialize(InputStream inputStream) throws IOException {
        this.dataInputStream.changeInputStream(inputStream);
        int logLength = this.dataInputStream.readInt();
        if (logLength <= 0) {
            LOGGER.error("Read log length {} is negative.", (Object)logLength);
            throw new IOException(new IllegalArgumentException(String.format("Read log length %s is negative.", logLength)));
        }
        byte[] logBuffer = new byte[logLength];
        if (logLength < inputStream.read(logBuffer, 0, logLength)) {
            throw new EOFException();
        }
        T result = this.deserializer.deserialize(ByteBuffer.wrap(logBuffer));
        this.dataInputStream.readLong();
        return result;
    }

    private static class ConfigurableDataInputStream
    extends DataInputStream {
        private ConfigurableDataInputStream(@NotNull InputStream in) {
            super(in);
        }

        private void changeInputStream(InputStream in) {
            this.in = in;
        }
    }
}

