/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class Cache
extends LinkedHashMap<Integer, Integer> {
    protected final int cacheCapacity;

    protected Cache(int cacheCapacity) {
        super(cacheCapacity, 0.75f, true);
        this.cacheCapacity = cacheCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Integer, Integer> eldest) {
        return this.size() > this.cacheCapacity;
    }

    public int getLast() {
        return (Integer)this.entrySet().iterator().next().getKey();
    }

    protected Integer putKey(Integer index) {
        return this.put(index, index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Cache cache = (Cache)o;
        return this.cacheCapacity == cache.cacheCapacity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cacheCapacity);
    }
}

