/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SearchedCaseExpression
extends Expression {
    private final List<WhenClause> whenClauses;
    @Nullable
    private final Expression defaultValue;

    public SearchedCaseExpression(List<WhenClause> whenClauses) {
        super(null);
        this.whenClauses = ImmutableList.copyOf((Collection)Objects.requireNonNull(whenClauses, "whenClauses is null"));
        this.defaultValue = null;
    }

    public SearchedCaseExpression(ByteBuffer byteBuffer) {
        super(null);
        int len = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Validate.isTrue((len > 0 ? 1 : 0) != 0, (String)"the length of SearchedCaseExpression's whenClauses must greater than 0", (Object[])new Object[0]);
        this.whenClauses = new ArrayList<WhenClause>();
        for (int i = 0; i < len; ++i) {
            Expression expression = Expression.deserialize(byteBuffer);
            this.whenClauses.add((WhenClause)expression);
        }
        this.defaultValue = Expression.deserialize(byteBuffer);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.SEARCHED_CASE;
    }

    public SearchedCaseExpression(List<WhenClause> whenClauses, Expression defaultValue) {
        super(null);
        this.whenClauses = ImmutableList.copyOf((Collection)Objects.requireNonNull(whenClauses, "whenClauses is null"));
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
    }

    public SearchedCaseExpression(NodeLocation location, List<WhenClause> whenClauses) {
        super(Objects.requireNonNull(location, "location is null"));
        this.whenClauses = ImmutableList.copyOf((Collection)Objects.requireNonNull(whenClauses, "whenClauses is null"));
        this.defaultValue = null;
    }

    public SearchedCaseExpression(NodeLocation location, List<WhenClause> whenClauses, Expression defaultValue) {
        super(Objects.requireNonNull(location, "location is null"));
        this.whenClauses = ImmutableList.copyOf((Collection)Objects.requireNonNull(whenClauses, "whenClauses is null"));
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Optional<Expression> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSearchedCaseExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.whenClauses);
        if (this.defaultValue != null) {
            nodes.add((Object)this.defaultValue);
        }
        return nodes.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchedCaseExpression that = (SearchedCaseExpression)o;
        return Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.whenClauses, this.defaultValue);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return SearchedCaseExpression.sameClass(this, other);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        int len = this.whenClauses.size();
        ReadWriteIOUtils.write((int)len, (ByteBuffer)byteBuffer);
        this.getWhenClauses().forEach(child -> Expression.serialize((Expression)child, byteBuffer));
        Expression.serialize(this.getDefaultValue().orElse(new NullLiteral()), byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.whenClauses.size(), (OutputStream)stream);
        for (Expression expression : this.getWhenClauses()) {
            Expression.serialize(expression, stream);
        }
        Expression.serialize(this.getDefaultValue().orElse(new NullLiteral()), stream);
    }
}

