/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class NumericParameter
extends DataTypeParameter {
    private final String value;

    public NumericParameter(String value) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public NumericParameter(@Nonnull NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNumericTypeParameter(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericParameter that = (NumericParameter)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!NumericParameter.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.value, ((NumericParameter)other).value);
    }
}

