/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class MeasureDefinition
extends Node {
    private final Expression expression;
    private final Identifier name;

    public MeasureDefinition(NodeLocation location, Expression expression, Identifier name) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMeasureDefinition(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("name", (Object)this.name).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasureDefinition that = (MeasureDefinition)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.name);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!MeasureDefinition.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.name, ((MeasureDefinition)other).name);
    }
}

