/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeStatement;

public class CreatePipe
extends PipeStatement {
    private final String pipeName;
    private final boolean ifNotExistsCondition;
    private final Map<String, String> extractorAttributes;
    private final Map<String, String> processorAttributes;
    private final Map<String, String> connectorAttributes;

    public CreatePipe(String pipeName, boolean ifNotExistsCondition, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) {
        this.pipeName = Objects.requireNonNull(pipeName, "pipe name can not be null");
        this.ifNotExistsCondition = ifNotExistsCondition;
        this.extractorAttributes = Objects.requireNonNull(extractorAttributes, "extractor/source attributes can not be null");
        this.processorAttributes = Objects.requireNonNull(processorAttributes, "processor attributes can not be null");
        this.connectorAttributes = Objects.requireNonNull(connectorAttributes, "connector attributes can not be null");
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean hasIfNotExistsCondition() {
        return this.ifNotExistsCondition;
    }

    public Map<String, String> getExtractorAttributes() {
        return this.extractorAttributes;
    }

    public Map<String, String> getProcessorAttributes() {
        return this.processorAttributes;
    }

    public Map<String, String> getConnectorAttributes() {
        return this.connectorAttributes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePipe(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeName, this.ifNotExistsCondition, this.extractorAttributes, this.processorAttributes, this.connectorAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePipe other = (CreatePipe)obj;
        return Objects.equals(this.pipeName, other.pipeName) && Objects.equals(this.ifNotExistsCondition, other.ifNotExistsCondition) && Objects.equals(this.extractorAttributes, other.extractorAttributes) && Objects.equals(this.processorAttributes, other.processorAttributes) && Objects.equals(this.connectorAttributes, other.connectorAttributes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pipeName", (Object)this.pipeName).add("ifNotExistsCondition", this.ifNotExistsCondition).add("extractorAttributes", this.extractorAttributes).add("processorAttributes", this.processorAttributes).add("connectorAttributes", this.connectorAttributes).toString();
    }
}

