/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.AggregationLabelSet;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public final class AggregationValuePointer
implements ValuePointer {
    private final ResolvedFunction function;
    private final AggregationLabelSet setDescriptor;
    private final List<Expression> arguments;
    private final Optional<Symbol> classifierSymbol;
    private final Optional<Symbol> matchNumberSymbol;

    public AggregationValuePointer(ResolvedFunction function, AggregationLabelSet setDescriptor, List<Expression> arguments, Optional<Symbol> classifierSymbol, Optional<Symbol> matchNumberSymbol) {
        this.function = Objects.requireNonNull(function, "function is null");
        this.setDescriptor = Objects.requireNonNull(setDescriptor, "setDescriptor is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.classifierSymbol = Objects.requireNonNull(classifierSymbol, "classifierSymbol is null");
        this.matchNumberSymbol = Objects.requireNonNull(matchNumberSymbol, "matchNumberSymbol is null");
    }

    public ResolvedFunction getFunction() {
        return this.function;
    }

    public AggregationLabelSet getSetDescriptor() {
        return this.setDescriptor;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Symbol> getClassifierSymbol() {
        return this.classifierSymbol;
    }

    public Optional<Symbol> getMatchNumberSymbol() {
        return this.matchNumberSymbol;
    }

    public List<Symbol> getInputSymbols() {
        return (List)this.arguments.stream().map(SymbolsExtractor::extractAll).flatMap(Collection::stream).filter(symbol -> !(this.classifierSymbol.isPresent() && this.classifierSymbol.get().equals(symbol) || this.matchNumberSymbol.isPresent() && this.matchNumberSymbol.get().equals(symbol))).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationValuePointer o = (AggregationValuePointer)obj;
        return Objects.equals(this.function, o.function) && Objects.equals(this.setDescriptor, o.setDescriptor) && Objects.equals(this.arguments, o.arguments) && Objects.equals(this.classifierSymbol, o.classifierSymbol) && Objects.equals(this.matchNumberSymbol, o.matchNumberSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.setDescriptor, this.arguments, this.classifierSymbol, this.matchNumberSymbol);
    }

    public static void serialize(AggregationValuePointer pointer, ByteBuffer byteBuffer) {
        pointer.function.serialize(byteBuffer);
        AggregationLabelSet.serialize(pointer.setDescriptor, byteBuffer);
        byteBuffer.putInt(pointer.arguments.size());
        for (Expression arg : pointer.arguments) {
            Expression.serialize(arg, byteBuffer);
        }
        byteBuffer.put(pointer.classifierSymbol.isPresent() ? (byte)1 : 0);
        if (pointer.classifierSymbol.isPresent()) {
            Symbol.serialize(pointer.classifierSymbol.get(), byteBuffer);
        }
        byteBuffer.put(pointer.matchNumberSymbol.isPresent() ? (byte)1 : 0);
        if (pointer.matchNumberSymbol.isPresent()) {
            Symbol.serialize(pointer.matchNumberSymbol.get(), byteBuffer);
        }
    }

    public static void serialize(AggregationValuePointer pointer, DataOutputStream stream) throws IOException {
        pointer.function.serialize(stream);
        AggregationLabelSet.serialize(pointer.setDescriptor, stream);
        stream.writeInt(pointer.arguments.size());
        for (Expression arg : pointer.arguments) {
            Expression.serialize(arg, stream);
        }
        stream.writeBoolean(pointer.classifierSymbol.isPresent());
        if (pointer.classifierSymbol.isPresent()) {
            Symbol.serialize(pointer.classifierSymbol.get(), stream);
        }
        stream.writeBoolean(pointer.matchNumberSymbol.isPresent());
        if (pointer.matchNumberSymbol.isPresent()) {
            Symbol.serialize(pointer.matchNumberSymbol.get(), stream);
        }
    }

    public static AggregationValuePointer deserialize(ByteBuffer byteBuffer) {
        ResolvedFunction function = ResolvedFunction.deserialize(byteBuffer);
        AggregationLabelSet setDescriptor = AggregationLabelSet.deserialize(byteBuffer);
        int argCount = byteBuffer.getInt();
        ArrayList<Expression> arguments = new ArrayList<Expression>(argCount);
        for (int i = 0; i < argCount; ++i) {
            arguments.add(Expression.deserialize(byteBuffer));
        }
        Optional<Symbol> classifierSymbol = byteBuffer.get() == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
        Optional<Symbol> matchNumberSymbol = byteBuffer.get() == 1 ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
        return new AggregationValuePointer(function, setDescriptor, arguments, classifierSymbol, matchNumberSymbol);
    }
}

