/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;

public class ValueFillNode
extends FillNode {
    private final Literal filledValue;

    public ValueFillNode(PlanNodeId id, PlanNode child, Literal filledValue) {
        super(id, child);
        this.filledValue = filledValue;
    }

    public Literal getFilledValue() {
        return this.filledValue;
    }

    @Override
    public PlanNode clone() {
        return new ValueFillNode(this.id, null, this.filledValue);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitValueFill(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_VALUE_FILL_NODE.serialize(byteBuffer);
        Expression.serialize((Expression)this.filledValue, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_VALUE_FILL_NODE.serialize(stream);
        Expression.serialize((Expression)this.filledValue, stream);
    }

    public static ValueFillNode deserialize(ByteBuffer byteBuffer) {
        Literal filledValue = (Literal)Expression.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new ValueFillNode(planNodeId, null, filledValue);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ValueFillNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.filledValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueFillNode that = (ValueFillNode)o;
        return Objects.equals(this.filledValue, that.filledValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filledValue);
    }

    public String toString() {
        return "ValueFillNode-" + this.getPlanNodeId();
    }
}

