/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableFunctionProcessorNode
extends SingleChildProcessNode {
    private final String name;
    private final List<Symbol> properOutputs;
    private final Optional<TableFunctionNode.PassThroughSpecification> passThroughSpecification;
    private final List<Symbol> requiredSymbols;
    private final Optional<DataOrganizationSpecification> dataOrganizationSpecification;
    private final boolean rowSemantic;
    private final TableFunctionHandle tableFunctionHandle;
    private final boolean requireRecordSnapshot;

    public TableFunctionProcessorNode(PlanNodeId id, String name, List<Symbol> properOutputs, Optional<PlanNode> source, Optional<TableFunctionNode.PassThroughSpecification> passThroughSpecification, List<Symbol> requiredSymbols, Optional<DataOrganizationSpecification> dataOrganizationSpecification, boolean rowSemantic, TableFunctionHandle tableFunctionHandle, boolean requireRecordSnapshot) {
        super(id, source.orElse(null));
        this.name = Objects.requireNonNull(name, "name is null");
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.passThroughSpecification = passThroughSpecification;
        this.requiredSymbols = ImmutableList.copyOf(requiredSymbols);
        this.dataOrganizationSpecification = Objects.requireNonNull(dataOrganizationSpecification, "specification is null");
        this.rowSemantic = rowSemantic;
        this.tableFunctionHandle = tableFunctionHandle;
        this.requireRecordSnapshot = requireRecordSnapshot;
    }

    public TableFunctionProcessorNode(PlanNodeId id, String name, List<Symbol> properOutputs, Optional<TableFunctionNode.PassThroughSpecification> passThroughSpecification, List<Symbol> requiredSymbols, Optional<DataOrganizationSpecification> dataOrganizationSpecification, boolean rowSemantic, TableFunctionHandle tableFunctionHandle, boolean requireRecordSnapshot) {
        super(id);
        this.name = Objects.requireNonNull(name, "name is null");
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.passThroughSpecification = passThroughSpecification;
        this.requiredSymbols = ImmutableList.copyOf(requiredSymbols);
        this.dataOrganizationSpecification = Objects.requireNonNull(dataOrganizationSpecification, "specification is null");
        this.rowSemantic = rowSemantic;
        this.tableFunctionHandle = tableFunctionHandle;
        this.requireRecordSnapshot = requireRecordSnapshot;
    }

    public String getName() {
        return this.name;
    }

    public List<Symbol> getProperOutputs() {
        return this.properOutputs;
    }

    public boolean isRowSemantic() {
        return this.rowSemantic;
    }

    public Optional<TableFunctionNode.PassThroughSpecification> getPassThroughSpecification() {
        return this.passThroughSpecification;
    }

    public List<Symbol> getRequiredSymbols() {
        return this.requiredSymbols;
    }

    public Optional<DataOrganizationSpecification> getDataOrganizationSpecification() {
        return this.dataOrganizationSpecification;
    }

    public TableFunctionHandle getTableFunctionHandle() {
        return this.tableFunctionHandle;
    }

    public boolean isRequireRecordSnapshot() {
        return this.requireRecordSnapshot;
    }

    @Override
    public PlanNode clone() {
        return new TableFunctionProcessorNode(this.id, this.name, this.properOutputs, this.passThroughSpecification, this.requiredSymbols, this.dataOrganizationSpecification, this.rowSemantic, this.tableFunctionHandle, this.requireRecordSnapshot);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll(this.properOutputs);
        this.passThroughSpecification.ifPresent(passThroughSpecification1 -> passThroughSpecification1.getColumns().stream().map(TableFunctionNode.PassThroughColumn::getSymbol).forEach(arg_0 -> ((ImmutableList.Builder)symbols).add(arg_0)));
        return symbols.build();
    }

    @Override
    public List<String> getOutputColumnNames() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll((Iterable)this.properOutputs.stream().map(Symbol::getName).collect(Collectors.toList()));
        this.passThroughSpecification.ifPresent(passThroughSpecification1 -> passThroughSpecification1.getColumns().stream().map(TableFunctionNode.PassThroughColumn::getSymbol).map(Symbol::getName).forEach(arg_0 -> ((ImmutableList.Builder)symbols).add(arg_0)));
        return symbols.build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionProcessor(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_FUNCTION_PROCESSOR_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.properOutputs.size(), (ByteBuffer)byteBuffer);
        this.properOutputs.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
        ReadWriteIOUtils.write((Boolean)this.passThroughSpecification.isPresent(), (ByteBuffer)byteBuffer);
        this.passThroughSpecification.ifPresent(passThroughSpecification1 -> passThroughSpecification1.serialize(byteBuffer));
        ReadWriteIOUtils.write((int)this.requiredSymbols.size(), (ByteBuffer)byteBuffer);
        this.requiredSymbols.forEach(symbol -> Symbol.serialize(symbol, byteBuffer));
        ReadWriteIOUtils.write((Boolean)this.dataOrganizationSpecification.isPresent(), (ByteBuffer)byteBuffer);
        if (this.dataOrganizationSpecification.isPresent()) {
            this.dataOrganizationSpecification.get().serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.rowSemantic, (ByteBuffer)byteBuffer);
        byte[] bytes = this.tableFunctionHandle.serialize();
        ReadWriteIOUtils.write((ByteBuffer)ByteBuffer.wrap(bytes), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.requireRecordSnapshot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_FUNCTION_PROCESSOR_NODE.serialize(stream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.properOutputs.size(), (OutputStream)stream);
        for (Symbol symbol : this.properOutputs) {
            Symbol.serialize(symbol, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.passThroughSpecification.isPresent(), (OutputStream)stream);
        if (this.passThroughSpecification.isPresent()) {
            this.passThroughSpecification.get().serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.requiredSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : this.requiredSymbols) {
            Symbol.serialize(symbol, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.dataOrganizationSpecification.isPresent(), (OutputStream)stream);
        if (this.dataOrganizationSpecification.isPresent()) {
            this.dataOrganizationSpecification.get().serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)this.rowSemantic, (OutputStream)stream);
        byte[] bytes = this.tableFunctionHandle.serialize();
        ReadWriteIOUtils.write((ByteBuffer)ByteBuffer.wrap(bytes), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.requireRecordSnapshot, (OutputStream)stream);
    }

    public static TableFunctionProcessorNode deserialize(ByteBuffer byteBuffer) {
        String name = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> properOutputs = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            properOutputs.add(Symbol.deserialize(byteBuffer));
        }
        boolean hasPassThroughSpecification = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        Optional<TableFunctionNode.PassThroughSpecification> passThroughSpecification = hasPassThroughSpecification ? Optional.of(TableFunctionNode.PassThroughSpecification.deserialize(byteBuffer)) : Optional.empty();
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> requiredSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            requiredSymbols.add(Symbol.deserialize(byteBuffer));
        }
        boolean hasDataOrganizationSpecification = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        Optional<DataOrganizationSpecification> dataOrganizationSpecification = hasDataOrganizationSpecification ? Optional.of(DataOrganizationSpecification.deserialize(byteBuffer)) : Optional.empty();
        boolean rowSemantic = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        byte[] bytes = ReadWriteIOUtils.readBytes((ByteBuffer)byteBuffer, (int)size);
        TableFunctionHandle tableFunctionHandle = new TableMetadataImpl().getTableFunction(name).createTableFunctionHandle();
        tableFunctionHandle.deserialize(bytes);
        boolean requireRecordSnapshot = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TableFunctionProcessorNode(planNodeId, name, properOutputs, passThroughSpecification, requiredSymbols, dataOrganizationSpecification, rowSemantic, tableFunctionHandle, requireRecordSnapshot);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newSources) {
        Optional<PlanNode> newSource = newSources.isEmpty() ? Optional.empty() : Optional.of((PlanNode)Iterables.getOnlyElement(newSources));
        return new TableFunctionProcessorNode(this.id, this.name, this.properOutputs, newSource, this.passThroughSpecification, this.requiredSymbols, this.dataOrganizationSpecification, this.rowSemantic, this.tableFunctionHandle, this.requireRecordSnapshot);
    }
}

