/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Measure;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PatternRecognitionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ExpressionAndValuePointers;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class ExpressionRewriteRuleSet {
    private final ExpressionRewriter rewriter;

    public ExpressionRewriteRuleSet(ExpressionRewriter rewriter) {
        this.rewriter = Objects.requireNonNull(rewriter, "rewriter is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    public Rule<?> projectExpressionRewrite() {
        return new ProjectExpressionRewrite(this.rewriter);
    }

    public Rule<?> filterExpressionRewrite() {
        return new FilterExpressionRewrite(this.rewriter);
    }

    public Rule<?> patternRecognitionExpressionRewrite() {
        return new PatternRecognitionExpressionRewrite(this.rewriter);
    }

    public static interface ExpressionRewriter {
        public Expression rewrite(Expression var1, Rule.Context var2);
    }

    private static final class ProjectExpressionRewrite
    implements Rule<ProjectNode> {
        private final ExpressionRewriter rewriter;

        ProjectExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
            Assignments assignments = projectNode.getAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (projectNode.getAssignments().equals(assignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ProjectNode(projectNode.getPlanNodeId(), projectNode.getChild(), assignments));
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.rewriter);
        }
    }

    private static final class FilterExpressionRewrite
    implements Rule<FilterNode> {
        private final ExpressionRewriter rewriter;

        FilterExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Expression rewritten = this.rewriter.rewrite(filterNode.getPredicate(), context);
            if (filterNode.getPredicate().equals(rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new FilterNode(filterNode.getPlanNodeId(), filterNode.getChild(), rewritten));
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.rewriter);
        }
    }

    private static final class PatternRecognitionExpressionRewrite
    implements Rule<PatternRecognitionNode> {
        private final ExpressionRewriter rewriter;

        PatternRecognitionExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<PatternRecognitionNode> getPattern() {
            return Patterns.patternRecognition();
        }

        @Override
        public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableMap.Builder rewrittenMeasures = ImmutableMap.builder();
            for (Map.Entry<Symbol, Measure> entry : node.getMeasures().entrySet()) {
                ExpressionAndValuePointers pointers = entry.getValue().getExpressionAndValuePointers();
                Optional<ExpressionAndValuePointers> newPointers = this.rewrite(pointers, context);
                if (newPointers.isPresent()) {
                    anyRewritten = true;
                    rewrittenMeasures.put((Object)entry.getKey(), (Object)new Measure(newPointers.get(), entry.getValue().getType()));
                    continue;
                }
                rewrittenMeasures.put(entry);
            }
            ImmutableMap.Builder rewrittenDefinitions = ImmutableMap.builder();
            for (Map.Entry<IrLabel, ExpressionAndValuePointers> entry : node.getVariableDefinitions().entrySet()) {
                ExpressionAndValuePointers pointers = entry.getValue();
                Optional<ExpressionAndValuePointers> newPointers = this.rewrite(pointers, context);
                if (newPointers.isPresent()) {
                    anyRewritten = true;
                    rewrittenDefinitions.put((Object)entry.getKey(), (Object)newPointers.get());
                    continue;
                }
                rewrittenDefinitions.put(entry);
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new PatternRecognitionNode(node.getPlanNodeId(), node.getChild(), node.getPartitionBy(), node.getOrderingScheme(), node.getHashSymbol(), (Map<Symbol, Measure>)rewrittenMeasures.buildOrThrow(), node.getRowsPerMatch(), node.getSkipToLabels(), node.getSkipToPosition(), node.getPattern(), (Map<IrLabel, ExpressionAndValuePointers>)rewrittenDefinitions.buildOrThrow()));
            }
            return Rule.Result.empty();
        }

        private Optional<ExpressionAndValuePointers> rewrite(ExpressionAndValuePointers pointers, Rule.Context context) {
            boolean rewritten = false;
            Expression newExpression = this.rewriter.rewrite(pointers.getExpression(), context);
            if (!pointers.getExpression().equals(newExpression)) {
                rewritten = true;
            }
            ImmutableList.Builder newAssignments = ImmutableList.builder();
            Set<Symbol> newSymbols = SymbolsExtractor.extractUnique(newExpression);
            for (ExpressionAndValuePointers.Assignment assignment : pointers.getAssignments()) {
                if (!newSymbols.contains(assignment.getSymbol())) continue;
                newAssignments.add((Object)new ExpressionAndValuePointers.Assignment(assignment.getSymbol(), assignment.getValuePointer()));
            }
            if (rewritten) {
                return Optional.of(new ExpressionAndValuePointers(newExpression, (List<ExpressionAndValuePointers.Assignment>)newAssignments.build()));
            }
            return Optional.empty();
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.rewriter);
        }
    }
}

