/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TopKNode
extends MultiChildProcessNode {
    public static final int LIMIT_VALUE_USE_TOP_K = 1000000;
    private final int topValue;
    private final OrderByParameter mergeOrderParameter;
    private final List<String> outputColumns;

    public TopKNode(PlanNodeId id, int topValue, OrderByParameter mergeOrderParameter, List<String> outputColumns) {
        super(id);
        this.topValue = topValue;
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
    }

    public TopKNode(PlanNodeId id, int topValue, List<PlanNode> children, OrderByParameter mergeOrderParameter, List<String> outputColumns) {
        super(id, children);
        this.topValue = topValue;
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TOP_K;
    }

    @Override
    public PlanNode clone() {
        return new TopKNode(this.getPlanNodeId(), this.getTopValue(), this.getMergeOrderParameter(), this.outputColumns);
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new TopKNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), this.getTopValue(), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)), this.getMergeOrderParameter(), this.outputColumns);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumns;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopK(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TOP_K.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.topValue, (ByteBuffer)byteBuffer);
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (ByteBuffer)byteBuffer);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TOP_K.serialize(stream);
        ReadWriteIOUtils.write((int)this.topValue, (OutputStream)stream);
        this.mergeOrderParameter.serializeAttributes(stream);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (OutputStream)stream);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (OutputStream)stream);
        }
    }

    public static TopKNode deserialize(ByteBuffer byteBuffer) {
        int topValue = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        OrderByParameter orderByParameter = OrderByParameter.deserialize(byteBuffer);
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); columnSize > 0; --columnSize) {
            outputColumns.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TopKNode(planNodeId, topValue, orderByParameter, outputColumns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopKNode that = (TopKNode)o;
        return this.topValue == that.getTopValue() && Objects.equals(this.mergeOrderParameter, that.getMergeOrderParameter());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.topValue, this.mergeOrderParameter);
    }

    public String toString() {
        return String.format("TopK-%s", this.getPlanNodeId());
    }

    public int getTopValue() {
        return this.topValue;
    }
}

